/* ================================================================================================ /
*
*	Diablo Mod: 
*	------------------
*
*	Need:		This compiled and items files
*	Works with:	AMXX  Cs 1.6
*
*	Installation:
*	-------------------
*	Copy script into plugins and edit plugins.ini
*	Copy item diablo directory into addons/amxmodx
*	If you amx directory is not called addons/amxmodx/.. just create a new path
*
*	Credits:
*	-----------------
*	Spacedude
*	Some others back when amx mod started :]	
*	twistedeuphoria
*
*	diablo_xpbonus = Xp on each kill (without bonus)
*	diablo_durability = Will your item loose durability on damage? And how much each time
*	diablo_saveitems = Save items when map changes
*	diablo_spawnchance = 1/x chance to spawn powerup on each roundstart
*
*	Contact:
*	-----------------
*	email: mortengryning@gmail.com
*
/ ================================================================================================= */

new Basepath[50] = "addons/amxmodx/diablo/"	//Path from Cstrike base directory

#include <amxmodx>
#include <engine>
#include <fakemeta> 
#include <fun>
#include <cstrike>
#include <amxmisc>

#define RESTORETIME 30.0	 //How long from server start can players still get their item trasferred (s)
#define MAX 32			 //Max number of valid player entities
//#define CHEAT 1		 //Cheat for testing purposes
#define CS_PLAYER_HEIGHT 72.0
#define GLOBAL_COOLDOWN 0.5
#define TASK_GREET 240
#define TASK_HUD 120
#define TASK_HOOK 360

#define x 0
#define y 1
#define z 2

//Version of the mod
new Float:version = 8.0

new gmsgFade
new gmsgDeathMsg
new gmsgStatusText
new gmsgBartimer
new gmsgScoreInfo

new bool:freeze_ended
new c4state[33]
new c4bombc[33][3] 
new c4fake[33]
new fired[33]
new bool:ghost_check
new ghosttime[33]
new ghoststate[33]
new sversion[16]

new sprite_blood_drop = 0
new sprite_blood_spray = 0
new sprite_gibs = 0
new sprite_white = 0
new sprite_fire = 0
new sprite_beam = 0
new sprite_boom = 0
new sprite_line = 0
new sprite_lgt = 0
new sprite_laser = 0
new sprite_ignite = 0
new sprite_smoke = 0

new player_xp[33] = 0		//Holds players experience
new player_lvl[33] = 1		//Holds players level
new player_point[33] = 0		//Holds players level points
new player_item_id[33] = 0	//Items id
new player_item_name[33][128]   //The items name
new player_intelligence[33]
new player_strength[33]
new player_agility[33]
new Float:player_damreduction[33]
new player_dextery[33]
new player_class[33]		
new Float:player_huddelay[33]

//Item attributes
new player_b_vampire[33] = 0	//Vampyric damage
new player_b_damage[33] = 0	//Bonus damage
new player_b_money[33] = 0	//Money bonus
new player_b_gravity[33] = 0	//Gravity bonus : 1 = best
new player_b_inv[33] = 0		//Invisibility bonus
new player_b_grenade[33] = 0	//Grenade bonus = 1/chance to kill
new player_b_reduceH[33] = 0	//Reduces player health each round start
new player_b_theif[33] = 0	//Amount of money to steal
new player_b_respawn[33] = 0	//Chance to respawn upon death
new player_b_explode[33] = 0	//Radius to explode upon death
new player_b_heal[33] = 0	//Ammount of hp to heal each 5 second
new player_b_gamble[33] = 0	//Random skill each round : value = vararity
new player_b_blind[33] = 0	//Chance 1/Value to blind the enemy
new player_b_fireshield[33] = 0	//Protects against explode and grenade bonus 
new player_b_meekstone[33] = 0	//Ability to lay a fake c4 and detonate 
new player_b_teamheal[33] = 0	//How many hp to heal when shooting a teammate 
new player_b_redirect[33] = 0	//How much damage will the player redirect 
new player_b_fireball[33] = 0	//Ability to shot off a fireball value = radius
new player_b_ghost[33] = 0	//Ability to walk through stuff
new player_b_eye[33] = 0		//Ability to place camera
new player_b_blink[33] = 0	//Ability to get a railgun
new player_b_windwalk[33] = 0	//Ability to windwalk away
new player_b_usingwind[33] = 0	//Is player using windwalk
new player_b_reverse[33] = 0	//Ability to reverse other players controls on hit
new player_b_froglegs[33] = 0	//Ability to hold down duck for 4 sec to frog-jump
new player_b_silent[33]	= 0	//Is player silent
new player_b_dagon[33] = 0	//Ability to nuke an opponent
new player_b_sniper[33] = 0	//Ability to kill in 1/sniper with scout
new player_b_jumpx[33] = 0	//Ability to double jump
new player_b_smokehit[33] = 0	//Ability to hit and kill with smoke :]
new player_b_extrastats[33] = 0	//Ability to gain extra stats
new player_b_firetotem[33] = 0	//Ability to put down a fire totem that explodes after 7 seconds
new player_b_hook[33] = 0	//Ability to grap a player a hook him towards you
new player_b_darksteel[33] = 0	//Ability to damage double from behind the target 	
new player_b_illusionist[33] = 0	//Ability to use the illusionist escape
new player_b_mine[33] = 0	//Ability to lay down mines

new player_dc_name[33][99]	//Information about last disconnected players name
new player_dc_item[33]		//Information about last disconnected players item
new player_c_name[33][50]	//Information about last map->now
new player_c_item[33]		//Information about alst map->now
new Float:player_b_oldsen[33]	//Players old sens


new bool:itemrestore = true	//Can playere restore item
new bool:updatedtable = false	//Has restore table been updated?
new bool:player_b_dagfired[33]	//Fired dagoon?
new bool:used_item[33] 
new jumps[33]			//Keeps charge with the number of jumps the user has made
new bool:dojump[33]		//Are we jumping?
new item_boosted[33]		//Has this user boosted his item?
new earthstomp[33]
new bool:falling[33]
new gravitytimer[33]
new item_durability[33]		//Durability of hold item

new LeaderCT = -1
new LeaderT = -1

enum { NONE = 0, SORC, MONK, PALADIN, ASSASSIN, NECROMANCER, BARBARIAN }
new Race[7][16] = { "None","Sorcerer","Monk","Paladin","Assassin","Necrom","Barbarian" }

new LevelXP[25] = { 0,25,85,185,300,450,700,850,1000,1335,1500,1800,2100,2400,2800,3200,3600,4000,
		    4500,5000,5500,6000,6500,100000000}

//Used for powerupsystem
new CTstart[3]
new Tstart[3]
new NextPowerup[3]
new bool:spawnset = false
new bool:havespawn = false
new bool:powerup_taken = false

//For Hook and powerup sy
new hooked[33]
new Float:player_global_cooldown[33]

//For optimization
new last_update_xp[33]
new Float:last_update_perc[33]
new bool:use_addtofullpack


//Flags a user can have
enum
{
	Flag_Ignite = 0,
	Flag_Hooking,
	Flag_Rot,
	Flag_Dazed,
	Flag_Illusion,
	Flag_Moneyshield,
	Flag_Teamshield,
	Flag_Teamshield_Target,
	num_of_flags
}


//Flags
new afflicted[33][num_of_flags]


/* PLUGIN CORE REDIRECTING TO FUNCTIONS ========================================================== */

public plugin_init()
{
	float_to_str(version,sversion,15)
	register_plugin("DiabloMod",sversion,"Morten") 
	register_cvar("diablomod_version",sversion,FCVAR_SERVER)
	register_event("CurWeapon","CurWeapon","be") 
	register_event("ResetHUD", "ResetHUD", "abe")
	register_event("DeathMsg","DeathMsg","ade") 
	register_event("Damage", "Damage", "b", "2!0")
	register_event("SendAudio","freeze_over","b","2=%!MRAD_GO","2=%!MRAD_MOVEOUT","2=%!MRAD_LETSGO","2=%!MRAD_LOCKNLOAD")
	register_event("SendAudio","freeze_begin","a","2=%!MRAD_terwin","2=%!MRAD_ctwin","2=%!MRAD_rounddraw") 
	register_event("SendAudio", "award_defuse", "a", "2&%!MRAD_BOMBDEF")  	
	register_logevent("award_plant", 3, "2=Planted_The_Bomb");	
	register_event("TextMsg", "award_hostageALL", "a", "2&#All_Hostages_R" ); 
	register_event("TextMsg","host_killed","b","2&#Killed_Hostage") 
	register_event("SendAudio","eventGrenade","bc","2=%!MRAD_FIREINHOLE")
	register_event("TextMsg", "freeze_begin", "a", "2=#Game_will_restart_in")
	register_clcmd("say /dropitem","dropitem") 
	register_clcmd("dropitem","dropitem") 
	register_clcmd("/dropitem","dropitem") 
	register_clcmd("say /iteminfo","iteminfo")
	register_clcmd("iteminfo","iteminfo")
	register_clcmd("/iteminfo","iteminfo")
	register_clcmd("say /item","iteminfo")
	register_clcmd("say /helpme","helpme") 
	register_clcmd("say /help","helpme") 
	register_clcmd("say /info","helpme")
	register_clcmd("say /changerace","changerace")
	register_clcmd("say changerace","changerace")
	register_clcmd("changerace","changerace")
	register_clcmd("say /change","changerace")
	register_clcmd("say /changeclass","changerace")
	register_clcmd("say changeclass","changerace")
	register_clcmd("say /skills", "showskills")
	register_clcmd("say skill", "showskills")
	register_clcmd("say /menu","showmenu") 
	register_clcmd("menu","showmenu")
	register_clcmd("helpme","helpme") 
	register_clcmd("say /rune","buyrune") 
	register_clcmd("/rune","buyrune") 
	register_clcmd("rune","buyrune") 
	register_clcmd("/skills","showskills")
	register_clcmd("/skillsinfo","showskills")
	register_clcmd("say /skillsinfo","showskills")
	register_clcmd("say /skills","showskills")
	register_menucmd(register_menuid("Select skill"), 1023, "skill_menu")
	register_menucmd(register_menuid("Options"), 1023, "option_menu")
	register_menucmd(register_menuid("Select Class "), 1023, "select_class_menu")
	register_menucmd(register_menuid("Select Rune "), 1023, "select_rune_menu")
	gmsgDeathMsg = get_user_msgid("DeathMsg")
	gmsgStatusText = get_user_msgid("StatusText")
	gmsgFade = get_user_msgid("ScreenFade")
	gmsgBartimer = get_user_msgid("BarTime") 
	gmsgScoreInfo = get_user_msgid("ScoreInfo") 
	register_cvar("diablo_saveitems","1",0) 
	register_cvar("diablo_xpbonus","25",0) 
	register_cvar("diablo_durability","10",0) 
	register_cvar("diablo_spawnchance","2",0)
	set_msg_block ( gmsgDeathMsg, BLOCK_SET ) 
	set_task(5.0, "Timed_Healing", 0, "", 0, "b")
	set_task(1.0, "Timed_Ghost_Check", 0, "", 0, "b")
	set_task(0.8, "UpdateHUD",0,"",0,"b")
	set_task(RESTORETIME, "DisableItemRestore",0,"",0,"a")
	register_think("PlayerCamera","Think_PlayerCamera");
	register_think("PowerUp","Think_PowerUp")
	register_think("Effect_Rot","Effect_Rot_Think")
	register_logevent("RoundStart", 2, "0=World triggered", "1=Round_Start")
	register_clcmd("fullupdate","fullupdate")
	register_forward(FM_WriteString, "FW_WriteString")
	register_think("Effect_Ignite_Totem", "Effect_Ignite_Totem_Think")
	register_think("Effect_Ignite", "Effect_Ignite_Think")
	register_think("Effect_Slow","Effect_Slow_Think")
	register_think("Effect_Timedflag","Effect_Timedflag_Think")
	register_think("Effect_MShield","Effect_MShield_Think")
	register_think("Mine","Mine_Think")
	register_think("Effect_Teamshield","Effect_Teamshield_Think")
	register_think("Effect_Healing_Totem","Effect_Healing_Totem_Think")
	register_forward(FM_AddToFullPack, "client_AddToFullPack")

	#if defined CHEAT
	register_clcmd("giveitem","giveitem")
	register_clcmd("bm","benchmark")
	#endif
	
	return PLUGIN_CONTINUE  
}

public plugin_precache()
{ 
	precache_model("models/rpgrocket.mdl")
	precache_model("models/bag.mdl")
	precache_model("models/zombie.mdl")
	precache_model("addons/amxmodx/diablo/mine.mdl")
	precache_model("addons/amxmodx/diablo/totem_ignite.mdl")
	precache_model("addons/amxmodx/diablo/totem_heal.mdl")
	precache_sound("weapons/xbow_hit2.wav")
	precache_sound("weapons/xbow_fire1.wav")
	sprite_blood_drop = precache_model("sprites/blood.spr")
	sprite_blood_spray = precache_model("sprites/bloodspray.spr")
	sprite_ignite = precache_model("addons/amxmodx/diablo/flame.spr")
	sprite_smoke = precache_model("sprites/steam1.spr")
	sprite_laser = precache_model("sprites/laserbeam.spr")
	sprite_boom = precache_model("sprites/zerogxplode.spr") 
	sprite_line = precache_model("sprites/dot.spr")
	sprite_lgt = precache_model("sprites/lgtning.spr")
	sprite_white = precache_model("sprites/white.spr") 
	sprite_fire = precache_model("sprites/explode1.spr") 
	sprite_gibs = precache_model("models/hgibs.mdl")
	sprite_beam = precache_model("sprites/zbeam4.spr") 

}

public freeze_over()
{
	freeze_ended = true
}

public freeze_begin()
{
	freeze_ended = false
}

public RoundStart()
{
	Findleader()
	SpawnPowerup()
	Bot_Setup()
	
	for (new i=0; i < 33; i++)
		used_item[i] = false
		
	ghost_check = false
	use_addtofullpack = false
}

#if defined CHEAT
public giveitem(id)
{
	award_item(id, 25)
	return PLUGIN_HANDLED
}

public benchmark(id)
{
	new Float:nowtime = halflife_time();
	new iterations = 10
	
	for (new i=0; i < iterations; i++)
	{
		UpdateHUD()
	}
	
	new Float:timespent = halflife_time()-nowtime
	
	client_print(id,print_chat,"Benchmark on: UpdateHUD() with %i iterations done in %f seconds",iterations,timespent)
}

#endif

/* BASIC FUNCTIONS ================================================================================ */

public CurWeapon(id)
{
	if (is_user_connected(id))
	{
		new clip, ammo
		new weapon = get_user_weapon(id,clip,ammo)
		
		if (player_item_id[id] == 17 || player_b_usingwind[id] == 1) engclient_cmd(id,"weapon_knife") 	
		if ((player_dextery[id] > 0 || player_class[id] == ASSASSIN) && freeze_ended) 
		{
			if (weapon != CSW_KNIFE ) 
			{
				new bonus = 0
				if (player_class[id] == ASSASSIN) bonus = 5
				set_user_maxspeed(id,250.0+player_dextery[id]+ bonus)
			}
			else 
			{
				set_user_maxspeed(id,252.0+player_dextery[id])
			}
		}
		
		add_inv_bonus(id)
		write_hud(id)
	}
}


public ResetHUD(id)
{
	if (is_user_connected(id))
	{	
		add_strength_bonus(id)
		if (c4fake[id] > 0)
		{
			remove_entity(c4fake[id])
			c4fake[id] = 0
		}
		
		fired[id] = 0
		player_b_dagfired[id] = false
		ghoststate[id] = 0
		earthstomp[id] = 0
		
		if (player_b_blink[id] > 0)
			player_b_blink[id] = 1
		
		if (player_b_usingwind[id] > 0) 
		{
			player_b_usingwind[id] = 0
			set_user_rendering(id,kRenderFxNone, 0,0,0, kRenderTransTexture,255)
		}
		
		if (player_point[id] > 0 ) skilltree(id)
		if (player_class[id] == 0) select_class(id)
		
		add_bonus_gamble(id)				//MUST be first
		c4state[id] = 0
		client_cmd(id,"hud_centerid 0")  
		auto_help(id)
		add_money_bonus(id)
		add_gravity_bonus(id)
		add_redhealth_bonus(id)
		SelectBotRace(id)
	}
}

public DeathMsg()
{
	new weaponname[20]
	new kid = read_data(1)
	new vid = read_data(2) 
	new headshot = read_data(3)
	read_data(4,weaponname,31)

	if (is_user_connected(kid) && is_user_connected(vid) && get_user_team(kid) != get_user_team(vid))
	{
		show_deadmessage(kid,vid,headshot,weaponname)
		award_item(kid,0)
		award_kill(kid,vid)
		add_respawn_bonus(vid)
		add_bonus_explode(vid)
		add_barbarian_bonus(kid)
		register_place(kid)
	}
}

public Damage(id)
{
	if (is_user_connected(id))
	{
		new damage = read_data(2)
		new weapon
		new bodypart
		new attacker_id = get_user_attacker(id,weapon,bodypart) 
		new starthealth = get_user_health(id)
		if (is_user_connected(attacker_id) && attacker_id != id)
		{
				
			add_damage_bonus(id,damage,attacker_id)
			add_vampire_bonus(id,damage,attacker_id)
			add_grenade_bonus(id,attacker_id,weapon)
			add_theif_bonus(id,attacker_id)
			add_bonus_blind(id,attacker_id,weapon,damage)
			add_bonus_confuse(id,attacker_id)
			add_bonus_redirect(id)
			add_bonus_necromancer(attacker_id,id)
			add_bonus_scoutdamage(attacker_id,id,weapon)	
			add_bonus_darksteel(attacker_id,id,damage)
			add_bonus_illusion(attacker_id,id,weapon)
			item_take_damage(id,damage)
			
			if (HasFlag(attacker_id,Flag_Ignite))
				RemoveFlag(attacker_id,Flag_Ignite)
			
			if((HasFlag(id,Flag_Illusion) || HasFlag(id,Flag_Teamshield))&& get_user_health(id) - damage > 0)
			{
				new weaponname[32]; get_weaponname( weapon, weaponname, 31 ); replace(weaponname, 31, "weapon_", "")
				UTIL_Kill(attacker_id,id,weaponname)
			}
			
			if (HasFlag(id,Flag_Moneyshield))
			{
				if (get_user_health(id)+3*damage/4 < 100+player_strength[id])
					set_user_health(id,get_user_health(id)+3*damage/4)
			}
				
			//Add the agility damage reduction, around 45% the curve flattens
			if (damage > 0 && player_agility[id] > 0)
			{	
				new heal = floatround(player_damreduction[id]*damage)
				if (get_user_health(id)+heal < starthealth && is_user_alive(id))
					set_user_health(id,get_user_health(id)+heal)
			}	
			
			if (HasFlag(id,Flag_Teamshield_Target))
			{
				//Find the owner of the shield
				new owner = find_owner_by_euser(id,"Effect_Teamshield")
				if (is_user_alive(owner))
					Hurt_Entity(owner,attacker_id,damage+0.0)
			}
		}
			
		#if defined CHEAT
		new name[32]
		get_user_name(id,name,31)
		if (equal(name,"Admin"))
		{
			set_user_health(id,100+player_strength[id])
			set_user_hitzones(0, id, 0)
		}

		#endif
			
	}
}

public client_PreThink ( id ) 
{

	//Before freeze_ended check
	if ((player_b_silent[id] > 0 || player_class[id] == ASSASSIN) && is_user_alive(id)) 
		entity_set_int(id, EV_INT_flTimeStepSound, 999)
	
	
	if (!freeze_ended)
		return PLUGIN_CONTINUE
	
	if (earthstomp[id] != 0 && is_user_alive(id))
	{
		static Float:fallVelocity;
		pev(id,pev_flFallVelocity,fallVelocity);

		if(fallVelocity) falling[id] = true
		else falling[id] = false;
	}

	
	if (player_b_jumpx[id] > 0) Prethink_Doublejump(id)
	if (player_b_blink[id] > 0) Prethink_Blink(id)	
	if (player_b_usingwind[id] == 1) Prethink_usingwind(id)
	if (player_b_oldsen[id] > 0) Prethink_confuseme(id)
	if (player_b_froglegs[id] > 0) Prethink_froglegs(id)

	
	//USE Button actives USEMAGIC
	if (pev(id,pev_button) & IN_USE )
		Use_Spell(id)
	
	return PLUGIN_CONTINUE	
	
}

public client_PostThink( id )
{
	if (player_b_jumpx[id] > 0) Postthink_Doubeljump(id)
	if (earthstomp[id] != 0 && is_user_alive(id))
	{
			if (!falling[id]) add_bonus_stomp(id)
			else set_pev(id,pev_watertype,-3)
	}
}

public client_AddToFullPack(ent_state,e,edict_t_ent,edict_t_host,hostflags,player,pSet) 
{
	//No players need this rather cpu consuming function - dont run
	if (!use_addtofullpack)
		return FMRES_HANDLED
		
	if (!pev_valid(e)|| !pev_valid(edict_t_ent) || !pev_valid(edict_t_host))
		return FMRES_HANDLED
			
	new classname[32]
	pev(e,pev_classname,classname,31)
	
	new hostclassname[32]
	pev(edict_t_host,pev_classname,hostclassname,31)
		
	
	if (equal(classname,"player") && equal(hostclassname,"player") && player)
	{
		// only take effect if both players are alive & and not somthing else like a ladder
		if (is_user_alive(e) && is_user_alive(edict_t_host) && e != edict_t_host) 
		{
			//host looks at e
			if (HasFlag(e,Flag_Illusion))
				return FMRES_SUPERCEDE
						
			//E Is looking at t and t has the flag
			if (HasFlag(edict_t_host,Flag_Illusion))
				return FMRES_SUPERCEDE			
		}
					
	}
	
	//Hide mines from enemies
	if (equal(classname,"Mine") && !player && equal(hostclassname,"player"))
	{
		new owner = pev(e,pev_owner)
					
		//Hide for enemies
		if (get_user_team(owner) != get_user_team(edict_t_host))
			set_rendering(e,kRenderFxNone, 0,0,0, kRenderTransTexture,60)	
	}
		
	return FMRES_HANDLED
		
}

/* FUNCTIONS ====================================================================================== */

public skilltree(id)
{
	new text[513] 
	new keys = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)
	
	
	format(text, 512, "\ySelect skill - \rPoints: %i^n^n\w1. Intelligence [%i] [More Spell Damage]^n\w2. Strength [%i] [More Hitpoints]^n\w3. Agility [%i] [Improved Magic find and Damage reduction]^n\w4. Dextery [%i] [Improved Speed and Magic damage reduction]",player_point[id],player_intelligence[id],player_strength[id],player_agility[id],player_dextery[id]) 
	
	keys = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)
	show_menu(id, keys, text) 
	return PLUGIN_HANDLED  
} 


public skill_menu(id, key) 
{ 
	switch(key) 
	{ 
		case 0: 
		{	
			player_point[id]-=1
			player_intelligence[id]+=1
			
		}
		case 1: 
		{	
			player_point[id]-=1	
			player_strength[id]+=1
			
			if (is_user_alive(id))
				set_user_health(id,get_user_health(id)+2)
		}
		case 2: 
		{	
			player_point[id]-=1
			player_agility[id]+=1
			player_damreduction[id] = (47.3057*(1.0-floatpower( 2.7182, -0.06798*float(player_agility[id])))/100)	
			
			
		}
		case 3: 
		{	
			player_point[id]-=1
			player_dextery[id]+=1
		}
	}
	
	if (player_point[id] > 0) 
		skilltree(id)
	
	
	return PLUGIN_HANDLED
}

/* ==================================================================================================== */

public show_deadmessage(killer_id,victim_id,headshot,weaponname[])
{
	if (!(killer_id==victim_id && !headshot && equal(weaponname,"world")))
	{
		message_begin( MSG_ALL, gmsgDeathMsg,{0,0,0},0)
		write_byte(killer_id)
		write_byte(victim_id)
		write_byte(headshot)
		write_string(weaponname)
		message_end()
	}
}

/* ==================================================================================================== */

public award_plant()
{
	new Players[32], playerCount, id
	get_players(Players, playerCount, "aeh", "TERRORIST") 
		
	for (new i=0; i<playerCount; i++) 
	{
		id = Players[i] 
		Give_Xp(id,get_cvar_num("diablo_xpbonus"))	
		client_print(id,print_chat,"You gained *%i* experience for bomb plant",get_cvar_num("diablo_xpbonus"))
	}	
}

public award_defuse()
{
	new Players[32], playerCount, id
	get_players(Players, playerCount, "aeh", "CT") 
		
	for (new i=0; i<playerCount; i++) 
	{
		id = Players[i] 
		Give_Xp(id,get_cvar_num("diablo_xpbonus"))	
		client_print(id,print_chat,"You gained *%i* experience for bomb defuse",get_cvar_num("diablo_xpbonus"))
	}
}

public award_hostageALL(id)
{
	if (is_user_connected(id) == 1)
		Give_Xp(id,get_cvar_num("diablo_xpbonus"))	
}

/* ==================================================================================================== */

public award_kill(killer_id,victim_id)
{
	if (!is_user_connected(killer_id) || !is_user_connected(victim_id))
		return PLUGIN_CONTINUE
		
	new xp_award = get_cvar_num("diablo_xpbonus")
		
	new Team[32]
	get_user_team(killer_id,Team,31)
	
	if (LeaderCT > 0 && equal(Team,"CT") && !is_user_alive(LeaderCT))
		xp_award-= get_cvar_num("diablo_xpbonus")/4
	
	if (LeaderT > 0 && equal(Team,"TERRORIST") && !is_user_alive(LeaderT))
		xp_award-= get_cvar_num("diablo_xpbonus")/4
	
	if (player_class[killer_id] == MONK) 
		xp_award+=get_cvar_num("diablo_xpbonus")/2
	
	if (player_xp[killer_id]<player_xp[victim_id]) 
		xp_award+=get_cvar_num("diablo_xpbonus")/4
	
	Give_Xp(killer_id,xp_award)
	
	return PLUGIN_CONTINUE
	
}

public Give_Xp(id,amount)
{
	player_xp[id]+=amount
	if (player_xp[id] > LevelXP[player_lvl[id]])
	{
		player_lvl[id]+=1
		player_point[id]+=2
		set_hudmessage(60, 200, 25, -1.0, 0.25, 0, 1.0, 2.0, 0.1, 0.2, 2)
		show_hudmessage(id, "You advanced to Level %i", player_lvl[id]) 
	}
	write_hud(id)
}

/* ==================================================================================================== */

public client_connect(id)
{
	reset_item_skills(id)
	player_xp[id] = 0		
	player_lvl[id] = 1		
	player_point[id] = 0	
	player_item_id[id] = 0			
	player_agility[id] = 0
	player_strength[id] = 0
	player_intelligence[id] = 0
	player_dextery[id] = 0
	player_b_oldsen[id] = 0.0
	player_class[id] = 0
	player_damreduction[id] = 0.0
	last_update_xp[id] = -1
	player_item_name[id] = "None"
	
	
	//Give player item back if he had it last map
	handle_mapchange(id)
	
	//Greet player
	set_task(10.0, "Greet_Player", id+TASK_GREET, "", 0, "a", 1)
}

public client_disconnect(id)
{
	new playername[40]
	get_user_name(id,playername,39)
	player_dc_name[id] = playername
	player_dc_item[id] = player_item_id[id]
	
	if (player_b_oldsen[id] > 0.0) 
		client_cmd(id,"sensitivity %f",player_b_oldsen[id])
}

/* ==================================================================================================== */

public write_hud(id)
{
	if (player_lvl[id] == 0)
		player_lvl[id] = 1
			
	new tpstring[512] 
	
	new Float:xp_now
	new Float:xp_need
	new Float:perc
	
	if (last_update_xp[id] == player_xp[id])
	{
		perc = last_update_perc[id]
	}
	else
	{
		
		//Calculate percentage of xp required to level
		if (player_lvl[id] == 1)
		{
			xp_now = float(player_xp[id])
			xp_need = float(LevelXP[player_lvl[id]])
			perc = xp_now*100.0/xp_need
		}
		else
		{
			xp_now = float(player_xp[id])-float( LevelXP[player_lvl[id]-1])
			xp_need = float(LevelXP[player_lvl[id]])-float(LevelXP[player_lvl[id]-1])
			perc = xp_now*100.0/xp_need
		}
	}
	
	last_update_xp[id] = player_xp[id]
	last_update_perc[id] = perc
	
	
	format(tpstring,511,"[Race: %s Lvl: %i (%0.0f%s) Item: %s]", Race[player_class[id]], player_lvl[id], perc,"%%",player_item_name[id])
	
	message_begin(MSG_ONE,gmsgStatusText,{0,0,0}, id) 
	write_byte(0) 
	write_string(tpstring) 
	message_end() 
}

/* ==================================================================================================== */

public UpdateHUD()
{   
	//Update HUD for each player
	for (new id=0; id < 32; id++)
	{	
		//If user is not connected, don't do anything
		if (!is_user_connected(id))
			continue
		
		
		if (is_user_alive(id)) write_hud(id)
		else
		{
			//Show info about the player we're looking at
			new index,bodypart 
			get_user_aiming(id,index,bodypart)  
			
			if(index >= 0 && index < MAX && is_user_connected(index) && is_user_alive(index)) 
			{
				new pname[32]
				get_user_name(index,pname,31)
				
				new Msg[512]
				set_hudmessage(255, 255, 255, 0.02, 0.63, 0, 6.0, 3.0)
				format(Msg,511,"Name: %s^nLevel: %i^nRace: %s^nItem: %s^nIntelligence: %i^nStrength: %i^nAgility: %i^nDextery: %i",pname,player_lvl[index],Race[player_class[index]],player_item_name[index], player_intelligence[index],player_strength[index], player_agility[index], player_dextery[index])		
				show_hudmessage(id, Msg)
				
			}
		}
	}
}

/* ==================================================================================================== */

public check_magic(id)					//Redirect and check which items will be triggered
{
	if (player_b_meekstone[id] > 0) item_c4fake(id)
	if (player_b_fireball[id] > 0) item_fireball(id)
	if (player_b_ghost[id] > 0) item_ghost(id)
	if (player_b_eye[id] != 0) item_eye(id)
	if (player_b_windwalk[id] > 0) item_windwalk(id)
	if (player_b_dagon[id] > 0) item_dagon(id)
	if (player_b_theif[id] > 0) item_convertmoney(id)
	if (player_b_firetotem[id] > 0) item_firetotem(id)
	if (player_b_hook[id] > 0) item_hook(id)
	if (player_b_gravity[id] > 0) item_gravitybomb(id)
	if (player_b_fireshield[id] > 0) item_rot(id)
	if (player_b_illusionist[id] > 0) item_illusion(id)
	if (player_b_money[id] > 0) item_money_shield(id)
	if (player_b_mine[id] > 0) item_mine(id)
	if (player_b_teamheal[id] > 0) item_teamshield(id)
	if (player_b_heal[id] > 0) item_totemheal(id)
	
	return PLUGIN_HANDLED
}

/* ==================================================================================================== */

public dropitem(id)
{
	if (player_item_id[id] == 0)
	{
		hudmsg(id,2.0,"You have no item to drop!")
		return PLUGIN_HANDLED
	} 
	
	
	if (item_durability[id] <= 0) 
	{
		hudmsg(id,3.0,"Item lost due to durability!")
	}
	else 
	{
		set_hudmessage(100, 200, 55, -1.0, 0.40, 0, 3.0, 2.0, 0.2, 0.3, 5)
		show_hudmessage(id, "Item dropped")
	}
	
	set_user_rendering(id,kRenderFxGlowShell,0,0,0,kRenderNormal,16)  
	player_item_id[id] = 0
	player_item_name[id] = "None"
	player_b_gamble[id] = 0					//Because gamble uses reset skills
	if (player_b_extrastats[id] > 0)
	{
		SubtractStats(id,player_b_extrastats[id])
	}
	reset_item_skills(id)
	write_hud(id)
	if (player_b_oldsen[id] > 0.0) 
	{
		client_cmd(id,"sensitivity %f",player_b_oldsen[id])
		player_b_oldsen[id] = 0.0
	}
	set_user_gravity(id,1.0)
	
	return PLUGIN_HANDLED
}

/* ==================================================================================================== */

public pfn_touch ( ptr, ptd )
{	
	if (ptd == 0)
		return PLUGIN_CONTINUE
		
	new szClassName[32]
	entity_get_string(ptd, EV_SZ_classname, szClassName, 31)
	
	if (ptr != 0)
	{
		new szClassNameOther[32]
		entity_get_string(ptr, EV_SZ_classname, szClassNameOther, 31)
		
		
		if(equal(szClassName, "PowerUp") && equal(szClassNameOther, "player"))
		{
			entity_set_int(ptd,EV_INT_iuser2,1)
			award_powerup(ptr)
		}
		
		if(equal(szClassName, "Mine") && equal(szClassNameOther, "player"))
		{
			new owner = pev(ptd,pev_owner)
			
			//Touch
			if (get_user_team(owner) != get_user_team(ptr))
			{
				new Float:origin[3]
				pev(ptd,pev_origin,origin)
				Explode_Origin(owner,origin,55+player_intelligence[owner],150)
				remove_entity(ptd)
			}
		}
		
		if(equal(szClassName, "grenade") && equal(szClassNameOther, "player"))
		{
			new greModel[64]
			entity_get_string(ptd, EV_SZ_model, greModel, 63)
			
			if(equali(greModel, "models/w_smokegrenade.mdl" ))	
			{
				new id = entity_get_edict(ptd,EV_ENT_owner)
				
				if (is_user_connected(id) 
				&& is_user_alive(id) 
				&& is_user_connected(ptr) 
				&& is_user_alive(ptr) 
				&& player_b_smokehit[id] > 0
				&& get_user_team(id) != get_user_team(ptr))
				UTIL_Kill(id,ptr,"grenade")
			}
			
			
		}
		
	}
	
	
	if(equal(szClassName, "fireball"))
	{
		new Float:origin[3]
		pev(ptd,pev_origin,origin)
		new id = pev(ptd,pev_owner)
		Explode_Origin(id,origin,100,player_b_fireball[id] + player_intelligence[id])
		remove_entity(ptd)
	}
	
	return PLUGIN_CONTINUE
}

/* ==================================================================================================== */

public Explode_Origin(id,Float:origin[3],damage,dist)
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(3)
	write_coord(floatround(origin[0]))
	write_coord(floatround(origin[1]))
	write_coord(floatround(origin[2]))
	write_short(sprite_boom)
	write_byte(50)
	write_byte(15)
	write_byte(0)
	message_end()
	
	new Players[32], playerCount, a
	get_players(Players, playerCount, "ah") 
	
	for (new i=0; i<playerCount; i++) 
	{
		a = Players[i] 
		
		new Float:aOrigin[3]
		pev(a,pev_origin,aOrigin)
				
		if (get_user_team(id) != get_user_team(a) && get_distance_f(aOrigin,origin) < dist+0.0)
		{
			new dam = damage-player_dextery[a]*2
					
			if (get_user_health(a)-dam < 5)
				UTIL_Kill(id,a,"grenade")
			else
			{
				set_user_health(a,get_user_health(a)-dam)
				Effect_Bleed(a,248)
			}
					
		}
		
	}
}

/* ==================================================================================================== */

public Timed_Healing()
{
	new Players[32], playerCount, a
	get_players(Players, playerCount, "ah") 
	
	for (new i=0; i<playerCount; i++) 
	{
		a = Players[i] 
		if (player_b_heal[a] <= 0)
			continue
		
		if (get_user_health(a)+player_b_heal[a] <= 100+player_strength[a]*2)
			set_user_health(a,get_user_health(a) + player_b_heal[a])
		else 
			set_user_health(a,100+player_strength[a]*2)
	}
}


/* ==================================================================================================== */

public Timed_Ghost_Check(id)
{
	if (ghost_check == true)
	{	
		new Globaltime = floatround(halflife_time())
		
		new Players[32], playerCount, a
		get_players(Players, playerCount, "h") 
		
		for (new i=0; i<playerCount; i++) 
		{
			a = Players[i] 
			
			if (ghoststate[a] == 2 && Globaltime - player_b_ghost[a] > ghosttime[a])
			{
				ghoststate[a] = 3
				ghosttime[a] = 0
				set_user_noclip(a,0)
				ghost_check = false
				new Float:aOrigin[3]
				entity_get_vector(a,EV_VEC_origin,aOrigin)	
				
				if (PointContents (aOrigin) != -1)
				{
					user_kill(a,1)	
				}
				else
				{
					aOrigin[2]+=10
					entity_set_vector(a,EV_VEC_origin,aOrigin)
				}
				
				
				
			}
			
		}
		
	}
}

public reset_item_skills(id)
{
	player_b_vampire[id] = 0	//Vampyric damage
	player_b_damage[id] = 0		//Bonus damage
	player_b_money[id] = 0		//Money bonus
	player_b_gravity[id] = 0	//Gravity bonus : 1 = best
	player_b_inv[id] = 0		//Invisibility bonus
	player_b_grenade[id] = 0	//Grenade bonus = 1/chance to kill
	player_b_reduceH[id] = 0	//Reduces player health each round start
	player_b_theif[id] = 0		//Amount of money to steal
	player_b_respawn[id] = 0	//Chance to respawn upon death
	player_b_explode[id] = 0	//Radius to explode upon death
	player_b_heal[id] = 0		//Ammount of hp to heal each 5 second
	player_b_blind[id] = 0		//Chance 1/Value to blind the enemy
	player_b_fireshield[id] = 0	//Protects against explode and grenade bonus 
	player_b_meekstone[id] = 0	//Ability to lay a fake c4 and detonate 
	player_b_teamheal[id] = 0	//How many hp to heal when shooting a teammate 
	player_b_redirect[id] = 0	//How much damage will the player redirect 
	player_b_fireball[id] = 0	//Ability to shot off a fireball value = radius *
	player_b_ghost[id] = 0		//Ability to walk through walls
	player_b_eye[id] = 0	         //Ability to snarkattack
	player_b_blink[id] = 0	//Abiliy to use railgun
	player_b_windwalk[id] = 0	//Ability to windwalk
	player_b_usingwind[id] = 0	//Is player using windwalk
	player_b_reverse[id] = 0
	player_b_froglegs[id] = 0
	player_b_silent[id] = 0
	player_b_dagon[id] = 0		//Abliity to nuke opponents
	player_b_sniper[id] = 0		//Ability to kill faster with scout
	player_b_jumpx[id] = 0
	player_b_smokehit[id] = 0
	player_b_extrastats[id] = 0
	player_b_firetotem[id] = 0
	player_b_hook[id] = 0
	player_b_darksteel[id] = 0
	player_b_illusionist[id] = 0
	player_b_mine[id] = 0 
	
	item_boosted[id] = 0
	item_durability[id] = 0		//Not holding an item
	jumps[id] = 0
	gravitytimer[id] = 0
}

/* ==================================================================================================== */

public auto_help(id)
{
	new rnd = random_num(1,5+player_lvl[id])
	if (rnd <= 5)
		set_hudmessage(0, 180, 0, -1.0, 0.70, 0, 10.0, 5.0, 0.1, 0.5, 11) 	
	if (rnd == 1)
		show_hudmessage(id, "You can drop an item by saying /dropitem and view info by saying /iteminfo")
	if (rnd == 2)
		show_hudmessage(id, "You can use specific items with the USE key - default is e")
	if (rnd == 3)
		show_hudmessage(id, "You can get more help by saying /helpme")
	if (rnd == 4)
		show_hudmessage(id, "Bind a key to MENU for a usefull diablo menu - this is most recommanded!")
	if (rnd == 5)
		show_hudmessage(id, "Some items can be upgraded with Runes. Type /rune for a shoplist")
}

/* ==================================================================================================== */

public helpme(id)
{	 
	showitem(id,"Helpmenu","Common","None","You gain items and xp by killing enemies, you can only gain an item if you're item slot is free<br><br>See what the item does by saying /iteminfo or drop it by saying /dropitem<br><br>Some items can be used with the USE button<br> Say /skills to see what attributes you have")
}

/* ==================================================================================================== */


/* ==================================================================================================== */

public showitem(id,itemname[],itemvalue[],itemeffect[],Durability[])
{
	new diabloDir[64]	
	new g_ItemFile[64]
	new amxbasedir[64]
	get_basedir(amxbasedir,63)
	
	format(diabloDir,63,"%s/diablo",amxbasedir)
	
	if (!dir_exists(diabloDir))
	{
		new errormsg[512]
		format(errormsg,511,"Error: The folder %s/diablo could not be found. Please copy this folder from the install package to the amxmodx folder",amxbasedir)
		show_motd(id, errormsg, "An error has occured")	
		return PLUGIN_HANDLED
	}
	
	
	format(g_ItemFile,63,"%s/diablo/item.txt",amxbasedir)
	if(file_exists(g_ItemFile))
		delete_file(g_ItemFile)
	
	new Data[768]
	
	//Header
	format(Data,767,"<html><head><title>Item Information</title></head>")
	write_file(g_ItemFile,Data,-1)
	
	//Background
	format(Data,767,"<body text=^"#FFFF00^" bgcolor=^"#000000^" background=^"%sdrkmotr.jpg^">",Basepath)
	write_file(g_ItemFile,Data,-1)
	
	//Table stuff
	format(Data,767,"<table border=^"0^" cellpadding=^"0^" cellspacing=^"0^" style=^"border-collapse: collapse^" width=^"100%s^"><tr><td width=^"0^">","^%")
	write_file(g_ItemFile,Data,-1)
	
	//ss.gif image
	format(Data,767,"<p align=^"center^"><img border=^"0^" src=^"%sss.gif^"></td>",Basepath)
	write_file(g_ItemFile,Data,-1)
	
	//item name
	format(Data,767,"<td width=^"0^"><p align=^"center^"><font face=^"Arial^"><font color=^"#FFCC00^"><b>Item: </b>%s</font><br>",itemname)
	write_file(g_ItemFile,Data,-1)
	
	//item value
	format(Data,767,"<font color=^"#FFCC00^"><b><br>Value: </b>%s</font><br>",itemvalue)
	write_file(g_ItemFile,Data,-1)
	
	//Durability
	format(Data,767,"<font color=^"#FFCC00^"><b><br>Durability: </b>%s</font><br><br>",Durability)
	write_file(g_ItemFile,Data,-1)
	
	//Effects
	format(Data,767,"<font color=^"#FFCC00^"><b>Effect:</b> %s</font></font></td>",itemeffect)
	write_file(g_ItemFile,Data,-1)
	
	//image ss
	format(Data,767,"<td width=^"0^"><p align=^"center^"><img border=^"0^" src=^"%sgf.gif^"></td>", Basepath)
	write_file(g_ItemFile,Data,-1)
	
	//end
	format(Data,767,"</tr></table></body></html>")
	write_file(g_ItemFile,Data,-1)
	
	//show window with message
	show_motd(id, g_ItemFile, "Item Information")
	
	return PLUGIN_HANDLED
	
}


/* ==================================================================================================== */

public iteminfo(id)
{
	new itemvalue[100]
	
	if (player_item_id[id] <= 10) itemvalue = "Common"
	if (player_item_id[id] <= 30) 
		itemvalue = "Uncommon"
	else 
		itemvalue = "Rare"
	
	if (player_item_id[id] > 42) itemvalue = "Unique"
	
	new itemEffect[200]
	
	new TempSkill[11]					//There must be a smarter way
	
	if (player_b_vampire[id] > 0) 
	{
		num_to_str(player_b_vampire[id],TempSkill,10)
		add(itemEffect,199,"Steals ")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," hit points when you hit an enemy<br>")
	}
	if (player_b_damage[id] > 0) 
	{
		num_to_str(player_b_damage[id],TempSkill,10)
		add(itemEffect,199,"Does ")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," Extra damage each time you damage an enemy<br>")
	}
	if (player_b_money[id] > 0) 
	{
		num_to_str(player_b_money[id],TempSkill,10)
		add(itemEffect,199,"Gives a $")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," + intelligene*50 money bonus each round start. Press USE to activate a shield that reduces normal damage with 50%<br>")
	}
	if (player_b_gravity[id] > 0) 
	{
		num_to_str(player_b_gravity[id],TempSkill,10)
		add(itemEffect,199,"Gravity is reduced with ")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199,". Press USE to earthstomp in the air. Damage done depends on the distance jumped and your strength<br>")
	}
	if (player_b_inv[id] > 0) 
	{
		num_to_str(player_b_inv[id],TempSkill,10)
		add(itemEffect,199,"You visibility is reduced from 255 to ")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199,"<br>")
	}
	if (player_b_grenade[id] > 0) 
	{
		num_to_str(player_b_grenade[id],TempSkill,10)
		add(itemEffect,199,"You have a 1/")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," chance that your HE will kill instantly<br>")
	}
	if (player_b_reduceH[id] > 0) 
	{
		num_to_str(player_b_reduceH[id],TempSkill,10)
		add(itemEffect,199,"Your health is reduced by ")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," each round start strength does not matter here<br>")
	}
	if (player_b_theif[id] > 0) 
	{
		num_to_str(player_b_theif[id],TempSkill,10)
		add(itemEffect,199,"Your have a 1/7 chance to steal $")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," each time you hit an enemy. You can also press USE to convert 1000$ into 15 health<br>")
	}
	if (player_b_respawn[id] > 0) 
	{
		num_to_str(player_b_respawn[id],TempSkill,10)
		add(itemEffect,199,"Your have a 1/")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," chance to respawn upon death<br>")
	}
	if (player_b_explode[id] > 0) 
	{
		num_to_str(player_b_explode[id],TempSkill,10)
		add(itemEffect,199,"When you die you will explode in a radius of ")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," dealing 75 damage to all around you - intelligence boost this item range<br>")
	}
	if (player_b_heal[id] > 0) 
	{
		num_to_str(player_b_heal[id],TempSkill,10)
		add(itemEffect,199,"You will gain +")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," hit points every 5 seconds. Press USE to put down a healing totem for 7 seconds<br>")
	}
	if (player_b_gamble[id] > 0) 
	{
		num_to_str(player_b_gamble[id],TempSkill,10)
		add(itemEffect,199,"You will gain a random skill each round start vararity is 1/")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199,"<br>")
	}
	if (player_b_blind[id] > 0) 
	{
		num_to_str(player_b_blind[id],TempSkill,10)
		add(itemEffect,199,"You have a 1/")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," chance to blind the enemy when you hit him<br>")
	}
	if (player_b_fireshield[id] > 0) 
	{
		num_to_str(player_b_fireshield[id],TempSkill,10)
		add(itemEffect,199,"You can not be killed by chaos orb, hell orb or firerope<br>")
		add(itemEffect,199,"Press USE to damage,slow and blind all enemies around you<br>")
	}
	if (player_b_meekstone[id] > 0) 
	{
		num_to_str(player_b_meekstone[id],TempSkill,10)
		add(itemEffect,199,"You can lay a fake c4 by using your USE key and blow them up by pressing USE again<br>")
	}
	if (player_b_teamheal[id] > 0) 
	{
		num_to_str(player_b_teamheal[id],TempSkill,10)
		add(itemEffect,199,"Press USE to activate a shield on a player.<br>")
		add(itemEffect,199," All shield damage is reflected. You die if you take damage")
	}
	if (player_b_redirect[id] > 0) 
	{
		num_to_str(player_b_redirect[id],TempSkill,10)
		add(itemEffect,199,"You gain a damage reduction of ")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," hitpoints<br>")
	}
	if (player_b_fireball[id] > 0) 
	{
		num_to_str(player_b_fireball[id],TempSkill,10)
		add(itemEffect,199,"You can cast a fireball pressing USE - Intelligence boost this item. It will kill all in a radius of ")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199,"<br>")
	}
	if (player_b_ghost[id] > 0) 
	{
		num_to_str(player_b_ghost[id],TempSkill,10)
		add(itemEffect,199,"Press USE to walk through walls in a period of ")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," seconds<br>")
	}
	if (player_b_eye[id] > 0) 
	{
		add(itemEffect,199,"Press USE to place a magic eye (only one placement allowed) and USE again to use it or stop ")
		
	}
	if (player_b_blink[id] > 0) 
	{
		add(itemEffect,199,"You can blink by using the alternative attack with your knife. Intelligence boost the blink distance")
	}
	
	if (player_b_windwalk[id] > 0) 
	{
		num_to_str(player_b_windwalk[id],TempSkill,10)
		add(itemEffect,199,"Press USE to become invisible unable to attack and with incresed speed for ")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," seconds.<br>")
	}
	
	if (player_b_reverse[id] > 0) 
	{
		num_to_str(player_b_reverse[id],TempSkill,10)
		add(itemEffect,199,"You have 1/")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," chance to confuse the victim you hit him<br>")
	}
	if (player_b_froglegs[id] > 0)
	{
		add(itemEffect,199,"You can hold down +DUCK 3 seconds to longjump")
	}
	if (player_b_dagon[id] == 1)
	{
		add(itemEffect,199,"Press USE to fire a lightning againt nearest opponent - you can upgrade this item with runes")
		add(itemEffect,199,"Intelligence will give this item more range")
	}
	if (player_b_sniper[id] > 0) 
	{
		num_to_str(player_b_sniper[id],TempSkill,10)
		add(itemEffect,199,"You have 1/")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," chance to instant kill with scout<br>")
	}
	if (player_b_jumpx[id] > 0)
	{
		num_to_str(player_b_jumpx[id],TempSkill,10)
		add(itemEffect,199,"You can jump ")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," extra times in the air while pressing the jump button<br>")	
	}
	if (player_b_smokehit[id] > 0)
	{
		add(itemEffect,199,"Your Smokegrandes will kill instantly if they hit the opponent")
	}
	if (player_b_extrastats[id] > 0)
	{
		num_to_str(player_b_extrastats[id],TempSkill,10)
		add(itemEffect,199,"You gain +")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," to each stat while holding this item")
	}
	if (player_b_firetotem[id] > 0)
	{
		num_to_str(player_b_firetotem[id],TempSkill,10)
		add(itemEffect,199,"Press USE to put down a firetotem which explode after 7s. It ignites anyone in a ")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," radius of the totem")
	}
	if (player_b_hook[id] > 0)
	{
		num_to_str(player_b_hook[id],TempSkill,10)
		add(itemEffect,199,"Press USE to throw out a hook with a range of 600 which pulls anyone it meets towards you. Intelligence makes the hook pull faster")
	}
	if (player_b_darksteel[id] > 0)
	{		
		new ddam = floatround(player_strength[id]*2*player_b_darksteel[id]/10.0)*3

		num_to_str(player_b_darksteel[id],TempSkill,10)
		add(itemEffect,199,"You get 15 + 0.")
		add(itemEffect,199,TempSkill)
		add(itemEffect,199,"*strength: ")
		num_to_str(ddam,TempSkill,10)
		add(itemEffect,199,TempSkill)
		add(itemEffect,199," damage bonus when you hit the enemy from behind ")
	}
	if (player_b_illusionist[id] > 0)
	{
		add(itemEffect,199,"Press USE to become invisible to all players for 7s. Any damage taken while invisible will kill you")
	}
	if (player_b_mine[id] > 0)
	{
		add(itemEffect,199,"Press USE to lay down an nearly invisible mine. Each mine explode for 50hp+intelligece damage on touch. 3 Mines each round is allowed.")
	}
	
	new Durability[10]
	num_to_str(item_durability[id],Durability,9)
	if (equal(itemEffect,"")) showitem(id,"None","None","Kill an enemy to recieve an item","None")
	if (!equal(itemEffect,"")) showitem(id,player_item_name[id],itemvalue,itemEffect,Durability)
	
}

/* ==================================================================================================== */

public award_item(id, itemnum)
{
	if (player_item_id[id] != 0)
		return PLUGIN_HANDLED
	
	set_hudmessage(220, 115, 70, -1.0, 0.40, 0, 3.0, 2.0, 0.2, 0.3, 5)
	new rannum = random_num(1,57)
	
	new maxfind = player_agility[id]
	if (maxfind > 15) maxfind = 15
	
	new rf = random_num(1,25-maxfind)
	
	if (itemnum > 0) rannum = itemnum
	else if (itemnum < 0) return PLUGIN_HANDLED
		
	if (rf == 3 && itemnum == 0)						//We found a rare item			
	{
		award_unique_item(id)	
		rannum = -1
	}				
	
	if (rannum == 1)
	{
		player_item_name[id] = "Bronze Amplifier"
		player_item_id[id] = rannum
		player_b_damage[id] = random_num(1,3)
		show_hudmessage(id, "Item found: %s :: +%i damage",player_item_name[id],player_b_damage[id])
	}
	
	if (rannum == 2)
	{
		player_item_name[id] = "Silver Amplifier"
		player_item_id[id] = rannum
		player_b_damage[id] = random_num(3,6)
		show_hudmessage(id, "Item found: %s :: +%i damage",player_item_name[id],player_b_damage[id])
	}
	
	if (rannum == 3)
	{
		player_item_name[id] = "Gold Amplifier"
		player_item_id[id] = rannum
		player_b_damage[id] = random_num(6,10)
		show_hudmessage(id, "Item found: %s :: +%i damage",player_item_name[id],player_b_damage[id])	
	}
	if (rannum == 4)
	{
		player_item_name[id] = "Vampyric Staff"
		player_item_id[id] = rannum
		player_b_vampire[id] = random_num(1,4)
		show_hudmessage(id, "Item found: %s :: +%i vampyric damage",player_item_name[id],player_b_vampire[id])	
	}
	if (rannum == 5)
	{
		player_item_name[id] = "Vampyric Amulet"
		player_item_id[id] = rannum
		player_b_vampire[id] = random_num(4,6)
		show_hudmessage(id, "Item found: %s :: +%i vampyric damage",player_item_name[id],player_b_vampire[id])	
	}
	if (rannum == 6)
	{
		player_item_name[id] = "Vampyric Scepter"
		player_item_id[id] = rannum
		player_b_vampire[id] = random_num(6,9)
		show_hudmessage(id, "Item found: %s :: +%i vampyric damage",player_item_name[id],player_b_vampire[id])	
	}
	if (rannum == 7)
	{
		player_item_name[id] = "Small bronze bag"
		player_item_id[id] = rannum
		player_b_money[id] = random_num(150,500)
		show_hudmessage(id, "Item found: %s :: +%i money each round. Press USE to shield you. Intelligence boost money given",player_item_name[id],player_b_money[id]+player_intelligence[id]*50)	
	}
	if (rannum == 8)
	{
		player_item_name[id] = "Medium silver bag"
		player_item_id[id] = rannum
		player_b_money[id] = random_num(500,1200)
		show_hudmessage(id, "Item found: %s :: +%i money each round. Press USE to shield you. Intelligence boost money given",player_item_name[id],player_b_money[id]+player_intelligence[id]*50)	
	}
	if (rannum == 9)
	{
		player_item_name[id] = "Large gold bag"
		player_item_id[id] = rannum
		player_b_money[id] = random_num(1200,3000)
		show_hudmessage(id, "Item found: %s :: +%i money each round. Press USE to shield you. Intelligence boost money given",player_item_name[id],player_b_money[id]+player_intelligence[id]*50)	
	}
	if (rannum == 10)
	{
		player_item_name[id] = "Small angel wings"
		player_item_id[id] = rannum
		player_b_gravity[id] = random_num(4,9)
		
		if (is_user_alive(id))
			add_gravity_bonus(id)
		show_hudmessage(id, "Item found: %s :: +%i gravity bonus - Press USE to earthstomp",player_item_name[id],10-player_b_gravity[id])	
	}
	if (rannum == 11)
	{
		player_item_name[id] = "Arch angel wings"
		player_item_id[id] = rannum
		player_b_gravity[id] = random_num(1,4)
		
		if (is_user_alive(id))
			add_gravity_bonus(id)
			
		show_hudmessage(id, "Item found: %s :: +%i gravity bonus - Press USE to earthstomp",player_item_name[id],10-player_b_gravity[id])	
		
	}
	if (rannum == 12)
	{
		player_item_name[id] = "Invisibility Rope"
		player_item_id[id] = rannum
		player_b_inv[id] = random_num(150,200)
		show_hudmessage(id, "Item found: %s :: +%i invisibility bonus",player_item_name[id],255-player_b_inv[id])	
	}
	if (rannum == 13)
	{
		player_item_name[id] = "Invisibility Coat"
		player_item_id[id] = rannum
		player_b_inv[id] = random_num(110,150)
		show_hudmessage(id, "Item found: %s :: +%i invisibility bonus",player_item_name[id],255-player_b_inv[id])	
	}
	if (rannum == 14)
	{
		player_item_name[id] = "Invisibility Armor"
		player_item_id[id] = rannum
		player_b_inv[id] = random_num(70,110)
		show_hudmessage(id, "Item found: %s :: +%i invisibility bonus",player_item_name[id],255-player_b_inv[id])	
	}
	if (rannum == 15)
	{
		player_item_name[id] = "Firerope"
		player_item_id[id] = rannum
		player_b_grenade[id] = random_num(3,6)
		show_hudmessage(id, "Item found: %s :: +1/%i chance to instant HE kill",player_item_name[id],player_b_grenade[id])	
	}
	if (rannum == 16)
	{
		player_item_name[id] = "Fire Amulet"
		player_item_id[id] = rannum
		player_b_grenade[id] = random_num(2,4)
		show_hudmessage(id, "Item found: %s :: +1/%i chance to instant HE kill",player_item_name[id],player_b_grenade[id])	
	}
	if (rannum == 17)
	{
		player_item_name[id] = "Stalkers ring"
		player_item_id[id] = rannum
		player_b_reduceH[id] = 95
		player_b_inv[id] = 9	
		
		if (is_user_alive(id)) set_user_health(id,5)		
		show_hudmessage(id, "Item found: %s :: 5 health - knife and nearly invisible",player_item_name[id])	
	}
	if (rannum == 18)
	{
		player_item_name[id] = "Arabian Boots"
		player_item_id[id] = rannum
		player_b_theif[id] = random_num(500,1000)
		show_hudmessage(id, "Item found: %s :: 1/5 chance to steal $%i each time you hit. Press USE to convert money to life",player_item_name[id],player_b_theif[id])	
	}
	if (rannum == 19)
	{
		player_item_name[id] = "Phoenix Ring"
		player_item_id[id] = rannum
		player_b_respawn[id] = random_num(3,6)
		show_hudmessage(id, "Item found: %s :: 1/%i chance to respawn upon death",player_item_name[id],player_b_respawn[id])	
	}
	if (rannum == 20)
	{
		player_item_name[id] = "Sorcerers ring"
		player_item_id[id] = rannum
		player_b_respawn[id] = random_num(2,3)
		show_hudmessage(id, "Item found: %s :: 1/%i chance to respawn upon death",player_item_name[id],player_b_respawn[id])	
	}
	if (rannum == 21)
	{
		player_item_name[id] = "Chaos Orb"
		player_item_id[id] = rannum
		player_b_explode[id] = random_num(150,275)
		show_hudmessage(id, "Item found: %s :: Explode in a radius of %i upon death",player_item_name[id],player_b_explode[id])	
	}
	if (rannum == 22)
	{
		player_item_name[id] = "Hell Orb"
		player_item_id[id] = rannum
		player_b_explode[id] = random_num(200,400)
		show_hudmessage(id, "Item found: %s :: Explode in a radius of %i upon death",player_item_name[id],player_b_explode[id])	
	}
	if (rannum == 23)
	{
		player_item_name[id] = "Gold statue"
		player_item_id[id] = rannum
		player_b_heal[id] = random_num(5,10)
		show_hudmessage(id, "Item found: %s :: Heals %i hp every 5 seconds. Press USE to put down a totem that heals all nearby for %i",player_item_name[id],player_b_heal[id],player_b_heal[id])	
	}
	if (rannum == 24)
	{
		player_item_name[id] = "Daylight Diamond"
		player_item_id[id] = rannum
		player_b_heal[id] = random_num(10,20)
		show_hudmessage(id, "Item found: %s :: Heals %i hp every 5 seconds. Press USE to put down a totem that heals all nearby for %i",player_item_name[id],player_b_heal[id],player_b_heal[id])	
	}
	if (rannum == 25)
	{
		player_item_name[id] = "Blood Diamond"
		player_item_id[id] = rannum
		player_b_heal[id] = random_num(20,35)
		show_hudmessage(id, "Item found: %s :: Heals %i hp every 5 seconds. Press USE to put down a totem that heals all nearby for %i",player_item_name[id],player_b_heal[id],player_b_heal[id])	
	}
	if (rannum == 26)
	{
		player_item_name[id] = "Wheel of Fortune"
		player_item_id[id] = rannum
		player_b_gamble[id] = random_num(2,3)
		show_hudmessage(id, "Item found: %s :: +%i to a random bonus each round",player_item_name[id],player_b_gamble[id])	
	}
	if (rannum == 27)
	{
		player_item_name[id] = "Four leaf Clover"
		player_item_id[id] = rannum
		player_b_gamble[id] = random_num(4,5)
		show_hudmessage(id, "Item found: %s :: +%i to a random bonus each round",player_item_name[id],player_b_gamble[id])	
	}
	if (rannum == 28)
	{
		player_item_name[id] = "Amulet of the sun"
		player_item_id[id] = rannum
		player_b_blind[id] = random_num(6,9)
		show_hudmessage(id, "Item found: %s :: 1/%i to blind the enemy when you damage him",player_item_name[id],player_b_blind[id])	
	}
	if (rannum == 29)
	{
		player_item_name[id] = "Sword of the sun"
		player_item_id[id] = rannum
		player_b_blind[id] = random_num(2,5)
		show_hudmessage(id, "Item found: %s :: 1/%i to blind the enemy when damaged",player_item_name[id],player_b_blind[id])	
	}
	if (rannum == 30)
	{
		player_item_name[id] = "Fireshield"
		player_item_id[id] = rannum
		player_b_fireshield[id] = 1
		show_hudmessage(id, "Item found: %s :: Protects against He instant kill and orbs. Press USE to rot",player_item_name[id],player_b_fireshield[id])	
	}
	if (rannum == 31)
	{
		player_item_name[id] = "Stealth Shoes"
		player_item_id[id] = rannum
		player_b_silent[id] = 1
		show_hudmessage(id, "Item found: %s :: Your run becomes silent",player_item_name[id])	
	}
	if (rannum == 32)
	{
		player_item_name[id] = "Meekstone"
		player_item_id[id] = rannum
		player_b_meekstone[id] = 1
		show_hudmessage(id, "Item found: %s :: Press USE to lay a fake bomb",player_item_name[id])	
	}
	if (rannum == 33)
	{
		player_item_name[id] = "Medicine Glar"
		player_item_id[id] = rannum
		player_b_teamheal[id] = random_num(10,20)
		show_hudmessage(id, "Item found: %s :: shoot at teammates to heal %i hp. Press USE to shield",player_item_name[id],player_b_teamheal[id])	
	}
	if (rannum == 34)
	{
		player_item_name[id] = "Medicine Totem"
		player_item_id[id] = rannum
		player_b_teamheal[id] = random_num(25,50)
		show_hudmessage(id, "Item found: %s :: shoot at teammates to heal %i hp. Press USE to shield",player_item_name[id],player_b_teamheal[id])	
	}
	if (rannum == 35)
	{
		player_item_name[id] = "Iron Armor"
		player_item_id[id] = rannum
		player_b_redirect[id] = random_num(3,6)
		show_hudmessage(id, "Item found: %s :: +%i Damage reduction",player_item_name[id],player_b_redirect[id])	
	}
	if (rannum == 36)
	{
		player_item_name[id] = "Mitril Armor"
		player_item_id[id] = rannum
		player_b_redirect[id] = random_num(6,11)
		show_hudmessage(id, "Item found: %s :: +%i Damage reduction",player_item_name[id],player_b_redirect[id])	
	}
	if (rannum == 37)
	{
		player_item_name[id] = "Godly Armor"
		player_item_id[id] = rannum
		player_b_redirect[id] = random_num(10,15)
		show_hudmessage(id, "Item found: %s :: +%i Damage reduction",player_item_name[id],player_b_redirect[id])	
	}
	if (rannum == 38)
	{
		player_item_name[id] = "Fireball staff"
		player_item_id[id] = rannum
		player_b_fireball[id] = random_num(50,100)
		show_hudmessage(id, "Item found: %s :: Will damage all in a radius of %i",player_item_name[id],player_b_fireball[id])	
	}
	if (rannum == 39)
	{
		player_item_name[id] = "Fireball scepter"
		player_item_id[id] = rannum
		player_b_fireball[id] = random_num(100,200)
		show_hudmessage(id, "Item found: %s :: Will damage all in a radius of %i",player_item_name[id],player_b_fireball[id])	
	}
	if (rannum == 40)
	{
		player_item_name[id] = "Ghost Rope"
		player_item_id[id] = rannum
		player_b_ghost[id] = random_num(3,6)
		show_hudmessage(id, "Item found: %s :: When activated you can walk through walls in %i sec",player_item_name[id],player_b_ghost[id])	
	}
	if (rannum == 41)
	{
		player_item_name[id] = "Nicolas Eye"
		player_item_id[id] = rannum
		player_b_eye[id] = -1
		show_hudmessage(id, "Item found: %s :: Press USE to place a camera and USE again to use/stop",player_item_name[id])	
	}
	if (rannum == 42)
	{
		player_item_name[id] = "Knife Ruby"
		player_item_id[id] = rannum
		player_b_blink[id] = floatround(halflife_time())
		show_hudmessage(id, "Item found: %s :: Your knife allows you to blink once every 3 seconds",player_item_name[id])	
	}
	if (rannum == 43)
	{
		player_item_name[id] = "Lothars Edge"
		player_item_id[id] = rannum
		player_b_windwalk[id] = random_num(4,7)
		show_hudmessage(id, "Item found: %s :: Press USE to become invisible %i seconds unable to attack and with increased speed",player_item_name[id],player_b_windwalk[id])	
	}
	if (rannum == 44)
	{
		player_item_name[id] = "Staff of the Earth"
		player_item_id[id] = rannum
		player_b_reverse[id] = random_num(2,4)
		show_hudmessage(id, "Item found: %s :: 1/%i chance to confuse an opponent when you hit him",player_item_name[id],player_b_reverse[id])	
	}
	if (rannum == 45)
	{
		player_item_name[id] = "Magic Booster"
		player_item_id[id] = rannum
		player_b_froglegs[id] = 1
		show_hudmessage(id, "Item found: %s :: Hold down +DUCK 3 second to long jump",player_item_name[id])	
	}
	if (rannum == 46)
	{
		player_item_name[id] = "Dagon I"
		player_item_id[id] = rannum
		player_b_dagon[id] = 1
		show_hudmessage(id, "Item found: %s :: Press the USE button to fire a lightning against nearest opponent",player_item_name[id],player_b_reverse[id])	
	}
	if (rannum == 47)
	{
		player_item_name[id] = "Scout Extender"
		player_item_id[id] = rannum
		player_b_sniper[id] = random_num(3,4)
		show_hudmessage(id, "Item found: %s :: 1/%i chance to instant kill with scout",player_item_name[id],player_b_sniper[id])	
	}
	if (rannum == 48)
	{
		player_item_name[id] = "Scout Amplifier"
		player_item_id[id] = rannum
		player_b_sniper[id] = random_num(2,3)
		show_hudmessage(id, "Item found: %s :: 1/%i chance to instant kill with scout",player_item_name[id],player_b_sniper[id])	
	}
	if (rannum == 49)
	{
		player_item_name[id] = "Air booster"
		player_item_id[id] = rannum
		player_b_jumpx[id] = 1
		show_hudmessage(id, "Item found: %s :: You can now double-jump in the air",player_item_name[id],player_b_sniper[id])	
	}
	if (rannum == 50)
	{
		player_item_name[id] = "Iron Spikes"
		player_item_id[id] = rannum
		player_b_smokehit[id] = 1
		show_hudmessage(id, "Item found: %s :: If you hit anyone directly in the air with your smoke grenades they will die",player_item_name[id])	
	}
	if (rannum == 51)
	{
		player_item_name[id] = "Point Booster"
		player_item_id[id] = rannum
		player_b_extrastats[id] = random_num(1,3)
		BoostStats(id,player_b_extrastats[id])
		show_hudmessage(id, "Item found: %s :: You gain +%i to each skill while wearing this item",player_item_name[id],player_b_extrastats[id])	
	}
	if (rannum == 52)
	{
		player_item_name[id] = "Totem amulet"
		player_item_id[id] = rannum
		player_b_firetotem[id] = random_num(250,400)
		show_hudmessage(id, "Item found: %s :: Press USE to lay down an explosive fire totem",player_item_name[id])	
	}
	if (rannum == 53)
	{
		player_item_name[id] = "Magic Hook"
		player_item_id[id] = rannum
		player_b_hook[id] = 1
		show_hudmessage(id, "Item found: %s :: Press USE to throw out a hook",player_item_name[id])	
	}
	if (rannum == 54)
	{
		player_item_name[id] = "Darksteel Glove"
		player_item_id[id] = rannum
		player_b_darksteel[id] = random_num(1,5)
		show_hudmessage(id, "Item found: %s :: Extra damage when you hit the target from behind",player_item_name[id])	
	}
	if (rannum == 55)
	{
		player_item_name[id] = "Darksteel Gaunlet"
		player_item_id[id] = rannum
		player_b_darksteel[id] = random_num(7,9)
		show_hudmessage(id, "Item found: %s :: Extra damage when you hit the target from behind",player_item_name[id])	
	}
	if (rannum == 56)
	{
		player_item_name[id] = "Illusionists Cape"
		player_item_id[id] = rannum
		player_b_illusionist[id] = 1
		show_hudmessage(id, "Item found: %s :: Press USE to become invisible to all",player_item_name[id])	
	}
	if (rannum == 57)
	{
		player_item_name[id] = "Techies scepter"
		player_item_id[id] = rannum
		player_b_mine[id] = 3
		show_hudmessage(id, "Item found: %s :: Press USE to lay down mines",player_item_name[id])
	}
	
	//Set durability, make this item dependant?
	item_durability[id] = 250
	
	
	return PLUGIN_CONTINUE
}

/* UNIQUE ITEMS ============================================================================================ */
//Names are generated from an array

public award_unique_item(id)
{
	new Unique_names_Suffix[10][100]
	new Unique_names_Prefix[10][100]
	
	Unique_names_Suffix[1] = "Saintly amulet "
	Unique_names_Suffix[2] = "Holy sword "
	Unique_names_Suffix[3] = "Small staff "
	Unique_names_Suffix[4] = "Bright rope "
	Unique_names_Suffix[5] = "Shiny scepter "
	
	Unique_names_Prefix[1] = "of the stars"
	Unique_names_Prefix[2] = "of power"
	Unique_names_Prefix[3] = "of zod"
	Unique_names_Prefix[4] = "of life"
	Unique_names_Prefix[5] = "of the sun"
	
	//Generate the items name
	
	new roll_1 = random_num(1,4)
	new roll_2 = random_num(1,4)
	
	new Unique_name[100]
	add(Unique_name,99,Unique_names_Suffix[roll_1])
	add(Unique_name,99,Unique_names_Prefix[roll_2])
	
	player_item_name[id] = Unique_name
	player_item_id[id] = 100				
	
	//Generate and apply the stats
	
	if (roll_1 == 1) player_b_damage[id] = random_num(1,5)
	if (roll_1 == 2) player_b_vampire[id] = random_num(1,5)
	if (roll_1 == 3) player_b_money[id] = random_num(2500,5000)
	if (roll_1 == 4) player_b_reduceH[id] = random_num(20,50)
	if (roll_1 == 5) player_b_blind[id] = random_num(3,5)
	
	
	
	if (roll_2 == 1) player_b_grenade[id] = random_num(1,4)
	if (roll_2 == 2) player_b_respawn[id] = random_num(2,4)
	if (roll_2 == 3) player_b_explode[id] = random_num(150,400)
	if (roll_2 == 4) player_b_redirect[id] = random_num(5,10)
	if (roll_2 == 5) player_b_heal[id] = random_num(1,15)
	
	item_durability[id] = 350
	
	set_hudmessage(220, 115, 70, -1.0, 0.40, 0, 3.0, 2.0, 0.2, 0.3, 5)
	show_hudmessage(id, "Uniqie Item found: %s", Unique_name)
	
}
/* EFFECTS ================================================================================================= */

public add_damage_bonus(id,damage,attacker_id)
{
	if (player_b_damage[attacker_id] > 0)
	{
		if (get_user_health(id) > player_b_damage[attacker_id])
		{
			set_user_health(id,get_user_health(id) - player_b_damage[attacker_id])
			
			if (random_num(1,2) == 1) Effect_Bleed(id,248)
		} 
		else 
		{
			set_user_health(id,random_num(1,5))
		}
	}
}

/* ==================================================================================================== */

public add_vampire_bonus(id,damage,attacker_id)
{
	if (player_b_vampire[attacker_id] > 0)
	{
		new maxhealth = 100+player_strength[attacker_id]*2
		
		
		if (get_user_health(attacker_id)+player_b_vampire[attacker_id] <= maxhealth)
		{
			set_user_health(attacker_id,get_user_health(attacker_id)+player_b_vampire[attacker_id])
		} 
		else 
		{
			set_user_health(attacker_id,maxhealth)
		}
	}
}

/* ==================================================================================================== */

public add_money_bonus(id)
{
	if (player_b_money[id] > 0)
	{
		if (cs_get_user_money(id) < 16000 - player_b_money[id]+player_intelligence[id]*50) 
		{
			cs_set_user_money(id,cs_get_user_money(id)+ player_b_money[id]+player_intelligence[id]*50) 
		} 
		else 
		{
			cs_set_user_money(id,16000)
		}
	}
}

/* ==================================================================================================== */

public add_gravity_bonus(id)
{
	if (player_b_gravity[id] > 0)
	{
		if (player_b_gravity[id] > 6)
			set_user_gravity(id,0.8)		
		if (player_b_gravity[id] > 4)
		{
			set_user_gravity(id,0.6)		
		}
		if (player_b_gravity[id] >= 1)
		{
			set_user_gravity(id,0.4)		
		}
	}
}

/* ==================================================================================================== */

public add_inv_bonus(id)
{
	if (player_b_inv[id] > 0)
		set_user_rendering(id,kRenderFxNone, 0,0,0, kRenderTransTexture,player_b_inv[id])
}

/* ==================================================================================================== */

public add_grenade_bonus(id,attacker_id,weapon)
{
	if (player_b_grenade[attacker_id] > 0 && weapon == CSW_HEGRENADE && player_b_fireshield[id] == 0)	//Fireshield check
	{
		new roll = random_num(1,player_b_grenade[attacker_id])
		if (roll == 1)
		{
			set_user_health(id, 0)
			message_begin( MSG_ALL, gmsgDeathMsg,{0,0,0},0) 
			write_byte(attacker_id) 
			write_byte(id) 
			write_byte(0) 
			write_string("grenade") 
			message_end() 
			set_user_frags(attacker_id, get_user_frags(attacker_id)+1) 
			set_user_frags(id, get_user_frags(id)+1)
			cs_set_user_money(attacker_id, cs_get_user_money(attacker_id)+150) 
		}
	}
}

/* ==================================================================================================== */

public add_redhealth_bonus(id)
{
	if (player_b_reduceH[id] > 0)
		set_user_health(id,100-player_b_reduceH[id])
}

/* ==================================================================================================== */

public add_theif_bonus(id,attacker_id)
{
	if (player_b_theif[attacker_id] > 0)
	{
		new roll1 = random_num(1,5)
		if (roll1 == 1)
		{
			if (cs_get_user_money(id) > player_b_theif[attacker_id])
			{
				cs_set_user_money(id,cs_get_user_money(id)-player_b_theif[attacker_id])
				if (cs_get_user_money(attacker_id) + player_b_theif[attacker_id] <= 16000)
				{
					cs_set_user_money(attacker_id,cs_get_user_money(id)+player_b_theif[attacker_id])		
				}
			}
			else
			{
				new allthatsleft = cs_get_user_money(id)
				cs_set_user_money(id,0)
				if (cs_get_user_money(attacker_id) + allthatsleft <= 16000)
				{
					cs_set_user_money(attacker_id,cs_get_user_money(id) + allthatsleft)			
				}
			}
		}
	}
}

/* ==================================================================================================== */

public add_respawn_bonus(id)
{
	if (player_b_respawn[id] > 0)
	{
		new svIndex[32] 
		num_to_str(id,svIndex,32)
		new roll = random_num(1,player_b_respawn[id])
		if (roll == 1)
		{
			new maxpl,players[32]
			get_players(players, maxpl) 
			if (maxpl > 2)
			{
				cs_set_user_money(id,cs_get_user_money(id)+4000)
				set_task(0.5,"respawn",0,svIndex,32) 		
			}
			else
			{
				set_hudmessage(220, 115, 70, -1.0, 0.40, 0, 3.0, 2.0, 0.2, 0.3, 5)
				show_hudmessage(id, "More than 2 players required for a succesfull respawn")	
			}
			
		}
	}
}

public respawn(svIndex[]) 
{ 
	new vIndex = str_to_num(svIndex) 
	spawn(vIndex);
}

/* ==================================================================================================== */

public add_bonus_explode(id)
{
	if (player_b_explode[id] > 0)
	{
		
		new origin[3] 
		get_user_origin(id,origin) 
		explode(origin,id,0)
		
		
		for(new a = 0; a < MAX; a++) 
		{ 
			if (!is_user_connected(a) || !is_user_alive(a) || player_b_fireshield[a] != 0 ||  get_user_team(a) == get_user_team(id))
				continue	
			
			new origin1[3]
			get_user_origin(a,origin1) 
			
			if(get_distance(origin,origin1) < player_b_explode[id] + player_intelligence[id]*2)
			{
				new dam = 75-(player_dextery[a]*2)
				
				if (get_user_health(a) - dam < 5)
					UTIL_Kill(id,a,"grenade")	
				else
				{
					set_user_health(a,get_user_health(a)-dam)
					Display_Fade(id,2600,2600,0,255,0,0,15)
				}
			}
		}
	}
}

public explode(vec1[3],playerid, trigger)
{ 
	message_begin( MSG_BROADCAST,SVC_TEMPENTITY,vec1) 
	write_byte( 21 ) 
	write_coord(vec1[0]) 
	write_coord(vec1[1]) 
	write_coord(vec1[2] + 32) 
	write_coord(vec1[0]) 
	write_coord(vec1[1]) 
	write_coord(vec1[2] + 1000)
	write_short( sprite_white ) 
	write_byte( 0 ) 
	write_byte( 0 ) 
	write_byte( 3 ) 
	write_byte( 10 ) 
	write_byte( 0 ) 
	write_byte( 188 ) 
	write_byte( 220 ) 
	write_byte( 255 ) 
	write_byte( 255 ) 
	write_byte( 0 ) 
	message_end() 
	
	message_begin( MSG_BROADCAST,SVC_TEMPENTITY) 
	write_byte( 12 ) 
	write_coord(vec1[0]) 
	write_coord(vec1[1]) 
	write_coord(vec1[2]) 
	write_byte( 188 ) 
	write_byte( 10 ) 
	message_end() 
	
	message_begin( MSG_BROADCAST,SVC_TEMPENTITY,vec1) 
	write_byte( 3 ) 
	write_coord(vec1[0]) 
	write_coord(vec1[1]) 
	write_coord(vec1[2]) 
	write_short( sprite_fire ) 
	write_byte( 65 ) 
	write_byte( 10 ) 
	write_byte( 0 ) 
	message_end() 
	
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY,{0,0,0},playerid) 
	write_byte(107) 
	write_coord(vec1[0]) 
	write_coord(vec1[1]) 
	write_coord(vec1[2]) 
	write_coord(175) 
	write_short (sprite_gibs) 
	write_short (25)  
	write_byte (10) 
	message_end() 
	if (trigger == 1)
	{
		set_user_rendering(playerid,kRenderFxNone, 0,0,0, kRenderTransAdd,0) 
	}
}

/* ==================================================================================================== */

public add_bonus_gamble(id)
{	
	if (player_b_gamble[id] > 0 && is_user_alive(id))
	{
		reset_item_skills(id)
		set_hudmessage(220, 115, 70, -1.0, 0.40, 0, 3.0, 2.0, 0.2, 0.3, 5)
		new roll = random_num(1,player_b_gamble[id])
		if (roll == 1)
		{
			show_hudmessage(id, "Round bonus: +5 damage")
			player_b_damage[id] = 5
		}
		if (roll == 2)
		{
			show_hudmessage(id, "Round bonus: +5 Gravity bonus")
			player_b_gravity[id] = 5
		}
		if (roll == 3)
		{
			show_hudmessage(id, "Round bonus: +5 vampyric damage")
			player_b_vampire[id] = 5
		}
		if (roll == 4)
		{
			show_hudmessage(id, "Round bonus: +10 Heal bonus every 5 seconds")
			player_b_heal[id] = 10
		}
		if (roll == 5)
		{
			show_hudmessage(id, "Round bonus: 1/3 chance to instant HE kill")
			player_b_grenade[id] = 3
		}
	}
}

/* ==================================================================================================== */

public add_bonus_blind(id,attacker_id,weapon,damage)
{
	if (player_b_blind[attacker_id] > 0 && weapon != 4)
	{
		new roll = random_num(1,player_b_blind[attacker_id])
		if (roll == 1)
		{
			message_begin(MSG_ONE,gmsgFade,{0,0,0},id)
			write_short( 1<<14 ) 
			write_short( 1<<14 ) 
			write_short( 1<<16 ) 
			write_byte( 255 ) 
			write_byte( 155 ) 
			write_byte( 50 ) 
			write_byte( 230 ) 
			message_end()
		}
		
	}
}

/* ==================================================================================================== */

public item_c4fake(id)
{ 
	if (c4state[id] > 1)
	{
		hudmsg(id,2.0,"You can only use meekstone one time each round")
		return PLUGIN_CONTINUE 
	}
	
	if (player_b_meekstone[id] > 0 && c4state[id] == 1 && is_user_alive(id) == 1 && freeze_ended == true)
	{
		explode(c4bombc[id],id,0)
		
		for(new a = 0; a < MAX; a++) 
		{ 
			if (is_user_connected(a) && is_user_alive(a))
			{			
				new origin1[3]
				get_user_origin(a,origin1) 
				
				if(get_distance(c4bombc[id],origin1) < 300 && get_user_team(a) != get_user_team(id))
				{
					UTIL_Kill(id,a,"grenade")
				}
			}
		}
		
		c4state[id] = 2
		remove_entity(c4fake[id])
		c4fake[id] = 0 
	}
	
	if (player_b_meekstone[id] > 0 && c4state[id] == 0 && c4fake[id] == 0 && is_user_alive(id) == 1 && freeze_ended == true)
	{
		new Float:pOrigin[3]
		entity_get_vector(id,EV_VEC_origin, pOrigin)
		c4fake[id] = create_entity("info_target")
		
		entity_set_model(c4fake[id],"models/w_backpack.mdl")
		entity_set_origin(c4fake[id],pOrigin)
		entity_set_string(c4fake[id],EV_SZ_classname,"fakec4")
		entity_set_edict(c4fake[id],EV_ENT_owner,id)
		entity_set_int(c4fake[id],EV_INT_movetype,6)
		
		
		new Float:aOrigin[3]
		entity_get_vector(c4fake[id],EV_VEC_origin, aOrigin)
		c4bombc[id][0] = floatround(aOrigin[0])
		c4bombc[id][1] = floatround(aOrigin[1])
		c4bombc[id][2] = floatround(aOrigin[2])
		c4state[id] = 1
	}
	
	return PLUGIN_CONTINUE 
}

/* ==================================================================================================== */

public item_fireball(id)
{
	if (fired[id] > 0)
	{
		hudmsg(id,2.0,"You can only use the fireball once each turn")
		return PLUGIN_HANDLED
	}
	
	if (fired[id] == 0 && player_b_fireball[id] > 0 && is_user_alive(id) == 1)
	{
		fired[id] = 1
		new Float:vOrigin[3]
		new fEntity
		entity_get_vector(id,EV_VEC_origin, vOrigin)
		fEntity = create_entity("info_target")
		entity_set_model(fEntity, "models/rpgrocket.mdl")
		entity_set_origin(fEntity, vOrigin)
		entity_set_int(fEntity,EV_INT_effects,64)
		entity_set_string(fEntity,EV_SZ_classname,"fireball")
		entity_set_int(fEntity,EV_INT_movetype,5)
		entity_set_edict(fEntity,EV_ENT_owner,id)
		
		//Send forward
		new Float:fl_iNewVelocity[3]
		VelocityByAim(id, 400, fl_iNewVelocity)
		entity_set_vector(fEntity, EV_VEC_velocity, fl_iNewVelocity)
		
		
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY) 
		write_byte(22) 
		write_short(fEntity) 
		write_short(sprite_beam) 
		write_byte(45) 
		write_byte(4) 
		write_byte(255) 
		write_byte(0) 
		write_byte(0) 
		write_byte(25)
		message_end() 
	}	
	return PLUGIN_HANDLED
}

/* ==================================================================================================== */

public add_bonus_redirect(id)
{
	if (player_b_redirect[id] > 0)
	{
		if (get_user_health(id)+player_b_redirect[id] <= 100)
		{
			set_user_health(id,get_user_health(id)+player_b_redirect[id])
		}
		
	}
}

/* ==================================================================================================== */

public item_ghost(id)
{
	if (ghoststate[id] == 0 && player_b_ghost[id] > 0 && is_user_alive(id) && !ghost_check)
	{
		set_user_noclip(id,1)
		ghoststate[id] = 2
		ghosttime[id] = floatround(halflife_time())
		ghost_check = true
		
		message_begin( MSG_ONE, gmsgBartimer, {0,0,0}, id ) 
		write_byte( player_b_ghost[id]+1 ) 
		write_byte( 0 ) 
		message_end() 
	}
	else
	{
		hudmsg(id,3.0,"Only one player can use the ghost ability at one time or item already used")
	}
}

/* ==================================================================================================== */

public add_strength_bonus(id)
{
	set_user_health(id,100+player_strength[id]*2)
}

/* ==================================================================================================== */

public add_bonus_darksteel(attacker,id,damage)
{
	if (player_b_darksteel[attacker] > 0)
	{
		if (UTIL_In_FOV(attacker,id) && !UTIL_In_FOV(id,attacker))
		{
			
			new dam = floatround (15+player_strength[id]*2*player_b_darksteel[id]/10.0)
			
			Effect_Bleed(id,248)
			Hurt_Entity(attacker,id,dam+0.0)
		}
	}
}

/* ==================================================================================================== */

public item_eye(id)
{
	if (player_b_eye[id] == -1)
	{
		//place camera
		new Float:playerOrigin[3]
		entity_get_vector(id,EV_VEC_origin,playerOrigin)
		new ent = create_entity("info_target") 
		entity_set_string(ent, EV_SZ_classname, "PlayerCamera") 
		entity_set_int(ent, EV_INT_movetype, MOVETYPE_NOCLIP) 
		entity_set_int(ent, EV_INT_solid, SOLID_NOT) 
		entity_set_edict(ent, EV_ENT_owner, id)
		entity_set_model(ent, "models/rpgrocket.mdl")  				//Just something
		entity_set_origin(ent,playerOrigin)
		entity_set_int(ent,EV_INT_iuser1,0)		//Viewing through this camera						
		set_rendering (ent,kRenderFxNone, 0,0,0, kRenderTransTexture,0)
		entity_set_float(ent,EV_FL_nextthink,halflife_time() + 0.01) 
		player_b_eye[id] = ent
	}
	else
	{
		//view through camera or stop viewing
		new ent = player_b_eye[id]
		if (!is_valid_ent(ent))
		{
			attach_view(id,id)
			return PLUGIN_HANDLED
		}
		new viewing = entity_get_int(ent,EV_INT_iuser1)
		
		if (viewing) 
		{	
			entity_set_int(ent,EV_INT_iuser1,0)
			attach_view(id,id)
		}	
		else 
		{
			entity_set_int(ent,EV_INT_iuser1,1)
			attach_view(id,ent)
		}
	}
	
	return PLUGIN_HANDLED
}

/* ==================================================================================================== */

//Called when PlayerCamera thinks
public Think_PlayerCamera(ent)
{
	new id = entity_get_edict(ent,EV_ENT_owner)
	
	//Check if player is still having the item and is still online
	if (!is_valid_ent(id) || player_b_eye[id] == 0 || !is_user_connected(id))
	{
		//remove entity
		if (is_valid_ent(id) && is_user_connected(id)) attach_view(id,id)
		remove_entity(ent)
	}
	else
	{
		//Dont use cpu when not alive anyway or not viewing
		if (!is_user_alive(id))
		{
			entity_set_float(ent,EV_FL_nextthink,halflife_time() + 3.0) 
			return PLUGIN_HANDLED
		}
		
		if (!entity_get_int(ent,EV_INT_iuser1))
		{
			entity_set_float(ent,EV_FL_nextthink,halflife_time() + 0.5) 
			return PLUGIN_HANDLED
		}
		
		entity_set_float(ent,EV_FL_nextthink,halflife_time() + 0.01) 
		
		//Find nearest player to camera
		new Float:pOrigin[3],Float:plOrigin[3],Float:ret[3]
		entity_get_vector(ent,EV_VEC_origin,plOrigin)
		new Float:distrec = 2000.0, winent = -1
		
		for (new i=0; i<MAX; i++) 
		{
			if (is_user_connected(i) && is_user_alive(i))
			{
				entity_get_vector(i,EV_VEC_origin,pOrigin)
				pOrigin[2]+=10.0
				if (trace_line ( 0, plOrigin, pOrigin, ret ) == i && vector_distance(pOrigin,plOrigin) < distrec)
				{
					winent = i
					distrec = vector_distance(pOrigin,plOrigin)
				}
			}	
		}
		
		//Traceline and updown is still revresed
		if (winent > -1)
		{
			new Float:toplayer[3], Float:ideal[3],Float:pOrigin[3]
			entity_get_vector(winent,EV_VEC_origin,pOrigin)
			pOrigin[2]+=10.0
			toplayer[0] = pOrigin[0]-plOrigin[0]
			toplayer[1] = pOrigin[1]-plOrigin[1]
			toplayer[2] = pOrigin[2]-plOrigin[2]
			vector_to_angle ( toplayer, ideal ) 
			ideal[0] = ideal[0]*-1
			entity_set_vector(ent,EV_VEC_angles,ideal)
		}
	}
	
	return PLUGIN_CONTINUE
}

public Create_Line(id,origin1[3],origin2[3],bool:draw)
{
	if (draw)
	{
		message_begin(MSG_ONE,SVC_TEMPENTITY,{0,0,0},id)
		write_byte(0)
		write_coord(origin1[0])	// starting pos
		write_coord(origin1[1])
		write_coord(origin1[2])
		write_coord(origin2[0])	// ending pos
		write_coord(origin2[1])
		write_coord(origin2[2])
		write_short(sprite_line)	// sprite index
		write_byte(1)		// starting frame
		write_byte(5)		// frame rate
		write_byte(2)		// life
		write_byte(3)		// line width
		write_byte(0)		// noise
		write_byte(255)	// RED
		write_byte(50)	// GREEN
		write_byte(50)	// BLUE					
		write_byte(155)		// brightness
		write_byte(5)		// scroll speed
		message_end()
	}
	
	new Float:ret[3],Float:fOrigin1[3],Float:fOrigin2[3]
	//So we dont hit ourself
	origin1[2]+=50
	IVecFVec(origin1,fOrigin1)
	IVecFVec(origin2,fOrigin2)
	new hit = trace_line ( 0, fOrigin1, fOrigin2, ret )
	return hit
	
}

/* ==================================================================================================== */

public Prethink_Blink(id)
{
	if( get_user_button(id) & IN_ATTACK2 && !(get_user_oldbutton(id) & IN_ATTACK2) && is_user_alive(id)) 
	{			
		new clip, ammo
		new weapon = get_user_weapon(id,clip,ammo)
		
		if (weapon == CSW_KNIFE)
		{
			if (halflife_time()-player_b_blink[id] <= 3) return PLUGIN_HANDLED		
			player_b_blink[id] = floatround(halflife_time())	
			UTIL_Teleport(id,300+15*player_intelligence[id])			
		}
	}
	return PLUGIN_CONTINUE
}

/* ==================================================================================================== */


//Called on end or mapchange -- Save items for players
public plugin_end() 
{
	new Datafile[64], amxbasedir[64]
	//build_path(Datafile,63,"$basedir/diablo/datafile.txt") 
	
	get_basedir(amxbasedir,63)
	format(Datafile,63,"%s/diablo/datafile.txt",amxbasedir)
	
	if(file_exists(Datafile)) delete_file(Datafile)
	
	//Write name and item for each player
	for (new i=0; i < MAX; i++)
	{
		if (player_dc_item[i] > 0 && player_dc_item[i] != 100) //unique
		{
			new data[100]
			format(data,99,"%s^"%i^"",player_dc_name[i],player_dc_item[i])
			write_file(Datafile,data)
		}
	}
}

/* ==================================================================================================== */

public handle_mapchange(id)
{
	if (!itemrestore) 
		return PLUGIN_HANDLED
	
	if (!updatedtable)
		updateitemtable()
	
	new currentname[32]
	get_user_name(id,currentname,31)
	
	for (new i=0; i < MAX; i++)
	{
		if (player_c_item[i] > 0)
		{
			if (equal(currentname,player_c_name[i]))
				award_item(id,player_c_item[i])
		}
	}
	
	return PLUGIN_CONTINUE
}

/* ==================================================================================================== */

public DisableItemRestore()
{
	itemrestore = false
}

/* ==================================================================================================== */

public updateitemtable()
{
	if (get_cvar_num("diablo_saveitems") == 0)
		return PLUGIN_HANDLED
	
	new Datafile[64], amxbasedir[64]
	
	get_basedir(amxbasedir,63)
	format(Datafile,63,"%s/diablo/datafile.txt",amxbasedir)
	
	
	if(file_exists(Datafile)) 
	{
		new linenum = 0
		new linedata[100]
		new readlen = 0
		while (read_file ( Datafile, linenum, linedata, 99, readlen ) != 0)
		{
			linenum++
			
			if (linenum > MAX+1)
			{
				//More entries than players, abort
				log_amx("More than %i entries in Datafile, aborting table update",linenum)
				return PLUGIN_HANDLED
			}
			
			new linebreak = contain ( linedata, "^"" )
			
			if (strlen(linedata) < linebreak+1)
				continue
			
			new itembreak = contain (linedata[linebreak+1], "^"")
			
			if (linebreak > -1 && itembreak > -1)
			{
				
				new name[50]
				new item[50]
				
				copyc ( name, linebreak, linedata, '"' ) 
				copyc ( item, itembreak, linedata[linebreak+1],'"')
				
				player_c_name[linenum-1] = name
				player_c_item[linenum-1] = str_to_num(item)	
			}
		}
		
		updatedtable = true
	}
	
	return PLUGIN_CONTINUE
}

/* ==================================================================================================== */

public item_convertmoney(id)
{
	new maxhealth = 100+player_strength[id]*2
	
	if (cs_get_user_money(id) < 1000)
		hudmsg(id,2.0,"Not enough money to convert into life")
	else if (get_user_health(id) == maxhealth)
		hudmsg(id,2.0,"You are already on mamixum life")
	else
	{
		cs_set_user_money(id,cs_get_user_money(id)-1000)
		
		if (get_user_health(id)+15<= maxhealth)
			set_user_health(id,get_user_health(id)+15)
		else 
			set_user_health(id,maxhealth)	
		
		Display_Fade(id,2600,2600,0,0,255,0,15)
	}
}

public item_windwalk(id)
{
	//First time this round
	if (player_b_usingwind[id] == 0)
	{
		new szId[10]
		num_to_str(id,szId,9)
		player_b_usingwind[id] = 1
		set_user_rendering(id,kRenderFxNone, 0,0,0, kRenderTransTexture,75)
		engclient_cmd(id,"weapon_knife") 
		set_user_maxspeed(id,500.0)
		
		new Float:val = player_b_windwalk[id] + 0.0
		set_task(val,"resetwindwalk",0,szId,32) 
		
		message_begin( MSG_ONE, gmsgBartimer, {0,0,0}, id ) 
		write_byte( player_b_windwalk[id]) 
		write_byte( 0 ) 
		message_end() 
	}
	
	//Disable again
	else if (player_b_usingwind[id] == 1)
	{
		set_user_rendering(id,kRenderFxNone, 0,0,0, kRenderTransTexture,255)
		player_b_usingwind[id] = 2
		set_user_maxspeed(id,270.0)
		message_begin( MSG_ONE, gmsgBartimer, {0,0,0}, id ) 
		write_byte( 0) 
		write_byte( 0 ) 
		message_end() 
	}
	
	//Already used
	else if (player_b_usingwind[id] == 2)
	{
		set_hudmessage(220, 30, 30, -1.0, 0.40, 0, 3.0, 2.0, 0.2, 0.3, 5)
		show_hudmessage(id, "You can only use this item once a turn") 
	}
	
}

public resetwindwalk(szId[])
{
	new id = str_to_num(szId)
	if (id < 0 || id > MAX)
	{
		log_amx("Error in resetwindwalk, id: %i out of bounds", id)
	}
	
	if (player_b_usingwind[id] == 1)
	{
		player_b_usingwind[id] = 2
		set_user_rendering(id,kRenderFxNone, 0,0,0, kRenderTransTexture,255)	
		set_user_maxspeed(id,270.0)
		message_begin( MSG_ONE, gmsgBartimer, {0,0,0}, id ) 
		write_byte( 0) 
		write_byte( 0 ) 
		message_end() 
	}
	
}

/* ==================================================================================================== */

public Prethink_usingwind(id)
{
	
	if( get_user_button(id) & IN_ATTACK && is_user_alive(id))
	{
		new buttons = pev(id,pev_button)
		set_pev(id,pev_button,(buttons & ~IN_ATTACK));
		return FMRES_HANDLED;	
	}
	
	if( get_user_button(id) & IN_ATTACK2 && is_user_alive(id))
	{
		new buttons = pev(id,pev_button)
		set_pev(id,pev_button,(buttons & ~IN_ATTACK2));
		return FMRES_HANDLED;	
	}
	
	return PLUGIN_CONTINUE
}

/* ==================================================================================================== */

public add_bonus_confuse(id,attacker_id)
{
	if (player_b_reverse[attacker_id] > 0 && !is_user_bot(id) && player_b_oldsen[id] == 0.0)
	{
		if (random_num(1,player_b_reverse[attacker_id]) == 1)
		{
			//Confuse the victim
			query_client_cvar(id, "sensitivity", "cvar_result_func"); 
			
			
			message_begin( MSG_ONE, get_user_msgid("StatusIcon"), {0,0,0}, id ) 
			write_byte( 1 )     
			write_string( "dmg_chem") 
			write_byte( 100 ) // red 
			write_byte( 100 ) // green 
			write_byte( 100 ) // blue 
			message_end()  
			
		}
		
	}
}

public cvar_result_func(id, const cvar[], const value[]) 
{ 
	player_b_oldsen[id] = str_to_float(value)
	new svIndex[32] 
	num_to_str(id,svIndex,32)
	set_task(2.5,"resetsens",0,svIndex,32) 		
	
	
}

public resetsens(svIndex[]) 
{ 
	new id = str_to_num(svIndex) 
	
	if (player_b_oldsen[id] > 0.0)
	{
		client_cmd(id,"sensitivity %f",player_b_oldsen[id])
		player_b_oldsen[id] = 0.0
	}
	
	message_begin( MSG_ONE, get_user_msgid("StatusIcon"), {0,0,0}, id ) 
	write_byte( 0 )     
	write_string( "dmg_chem") 
	write_byte( 100 ) // red 
	write_byte( 100 ) // green 
	write_byte( 100 ) // blue 
	message_end()  
	
	
} 


/* ==================================================================================================== */

public Prethink_confuseme(id)
{
	if (player_b_oldsen[id] > 0.0)
		client_cmd(id,"sensitivity %f", 25.0)
	
}

/* ==================================================================================================== */

public Findleader()
{
	//Finds a leader for both teams
	new numCT, numT, IDSCT[MAX], IDST[MAX]
	
	for (new i=0; i < MAX; i++)
	{
		if (is_user_connected(i) && is_user_alive(i))
		{
			new team[32]
			get_user_team(i,team,31)
			if (equal(team,"TERRORIST"))
			{
				IDST[numT] = i
				numT++
			}
			else if (equal(team,"CT"))
			{
				IDSCT[numCT] = i
				numCT++
			}
		}
	}
	
	LeaderCT = IDSCT[random_num(0,numCT)]
	LeaderT = IDST[random_num(0,numT)]
	
	//PowerUp system takes Position from leader as basic
	if (is_user_connected(LeaderCT) && is_user_connected(LeaderT))
	{
		get_user_origin(LeaderCT,CTstart,0)
		get_user_origin(LeaderT,Tstart,0)
		spawnset = true
	}
	
	set_hudmessage(60, 100, 25, -1.0, 0.25, 0, 1.0, 2.0, 0.1, 0.2, 2)
	show_hudmessage(LeaderCT, "You are selected as leader. You and your teammates will get extra xp while you're alive") 
	show_hudmessage(LeaderT, "You are selected as leader. You and your teammates will get extra xp while you're alive") 
	
}

/* ==================================================================================================== */

public Bot_Setup()
{
	for (new id=0; id < MAX; id++)
	{
		if (is_user_connected(id) && is_user_bot(id))
		{
			if (random_num(1,3) == 1 && player_item_id[id] > 0)
				client_cmd(id,"say /dropitem")
			
			while (player_point[id] > 0)
			{
				player_point[id]--
				switch(random_num(1,4))
				{
					case 1: {
						player_agility[id]++
					}
					case 2: {
						player_strength[id]++
					}
					case 3: {
						player_intelligence[id]++
					}
					case 4: {
						player_dextery[id]++
					}
				}
			}
		}
	}
}

/* ==================================================================================================== */

public host_killed(id)
{
	if (player_lvl[id] > 1)
	{
		hudmsg(id,2.0,"You loose experience by killing hostages")
		
		if (player_xp[id]-get_cvar_num("diablo_xpbonus") < LevelXP[player_lvl[id]]-1)
			player_xp[id] = LevelXP[player_lvl[id]]-1
		else
			player_xp[id]-=get_cvar_num("diablo_xpbonus")
	}
	
}


/* ==================================================================================================== */

public showmenu(id)
{
	new text[513] 
	new keys = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)
	
	
	format(text, 512, "\yOptions - ^n\w1. Item Information^n\w2. Drop Current Item^n\w3. Show Help^n\w4. Use items ultimate^n\w5. Buy Rune^n\w6. Skills Information^n\w7. Exit") 
	
	show_menu(id, keys, text) 
	return PLUGIN_HANDLED  
} 


public option_menu(id, key) 
{ 
	switch(key) 
	{ 
		case 0: 
		{	
			iteminfo(id)
			
		}
		case 1: 
		{	
			dropitem(id)
		}
		case 2: 
		{	
			helpme(id)
		}
		case 3:
		{
			Use_Spell(id)
		}
		case 4:
		{
			buyrune(id)
		}
		case 5:
		{
			showskills(id)
		}
		case 6:
		{
			return PLUGIN_HANDLED
		}
	}
	
	return PLUGIN_HANDLED
}

public Prethink_froglegs(id)
{
	if (get_user_button(id) & IN_DUCK)
	{
		//start holding down button here, set to halflife time
		if (player_b_froglegs[id] == 1) 
		{
			player_b_froglegs[id] = floatround(halflife_time())
		}
		else
		{
			if (floatround(halflife_time())-player_b_froglegs[id] >= 2.0)
			{
				new Float:fl_iNewVelocity[3]
				VelocityByAim(id, 1000, fl_iNewVelocity)
				fl_iNewVelocity[2] = 210.0
				entity_set_vector(id, EV_VEC_velocity, fl_iNewVelocity)
				player_b_froglegs[id] = 1
			}
		}
	}
	else
	{
		player_b_froglegs[id] = 1
	}
}

/* ==================================================================================================== */

public select_class(id)
{
	new text[513] 
	new keys = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)
	
	format(text, 512, "\ySelect Class - ^n\w1. Sorcerer [Increased effect of spells]^n\w2. Paladin [Bonus to strength]^n\w3. Monk [More Experienced gained]^n\w4. Assassin [Faster and no footsteps]^n\w5. Barbarian [Regain hitpoint upon kill]^n\w6. Necromancer [Returns some of the damage taken]") 
	
	keys = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)
	show_menu(id, keys, text) 
	return PLUGIN_HANDLED  
} 


public select_class_menu(id, key) 
{ 
	switch(key) 
	{ 
		case 0: 
		{	
			player_class[id] = SORC
			player_intelligence[id]+=4
			
		}
		case 1: 
		{	
			player_class[id] = PALADIN
			player_strength[id]+=4
			if (is_user_alive(id))
				set_user_health(id,get_user_health(id)+8)
		}
		case 2: 
		{	
			player_class[id] = MONK
		}
		case 3: 
		{	
			player_class[id] = ASSASSIN
		}
		case 4: 
		{	
			player_class[id] = BARBARIAN
		}
		case 5: 
		{	
			player_class[id] = NECROMANCER
		}
	}
	
	if (player_class[id] == 0) select_class(id)
	return PLUGIN_HANDLED
}

/* ==================================================================================================== */

public add_barbarian_bonus(id)
{
	if (player_class[id] == BARBARIAN)
	{	
		new maxhealth = 100+player_strength[id]*2
		
		
		if (get_user_health(id)+50 <= maxhealth)
		{
			set_user_health(id,get_user_health(id)+50)
		} 
		else 
		{
			set_user_health(id,maxhealth)
		}
	}
}

/* ==================================================================================================== */

public add_bonus_necromancer(attacker_id,id)
{
	if (player_class[attacker_id] == NECROMANCER)
	{
		if (get_user_health(id) - 10 <= 0)
		{
			set_user_health(id,random_num(1,3))
		}
		else
		{
			set_user_health(id,get_user_health(id)-10)
		}
	}
}

/* ==================================================================================================== */

//What modules are required
public plugin_modules()
{
	require_module("engine")
	require_module("cstrike")
	require_module("fun")
	require_module("fakemeta")
}

/* ==================================================================================================== */

//Find the nearest alive opponent in our view
public UTIL_FindNearestOpponent(id,maxdist)
{
	new best = 99999
	new entfound = -1
	new MyOrigin[3]
	get_user_origin(id,MyOrigin)
	
	for (new i=1; i < MAX; i++)
	{
		if (i == id || !is_user_connected(i) || !is_user_alive(i) || get_user_team(id) == get_user_team(i))
			continue
		
		new TempOrigin[3],Float:fTempOrigin[3]
		get_user_origin(i,TempOrigin)
		IVecFVec(TempOrigin,fTempOrigin)
		
		if (!UTIL_IsInView(id,i))
			continue
		
		
		new dist = get_distance ( MyOrigin,TempOrigin ) 
		
		if ( dist < maxdist && dist < best)
		{
			best = dist
			entfound = i
		}		
	}
	
	return entfound
}

/* ==================================================================================================== */

//Basicly see's if we can draw a straight line to the target without interference
public bool:UTIL_IsInView(id,target)
{
	new Float:IdOrigin[3], Float:TargetOrigin[3], Float:ret[3] 
	new iIdOrigin[3], iTargetOrigin[3]
	
	get_user_origin(id,iIdOrigin,1)
	get_user_origin(target,iTargetOrigin,1)
	
	IVecFVec(iIdOrigin,IdOrigin)
	IVecFVec(iTargetOrigin, TargetOrigin)
	
	if ( trace_line ( 1, IdOrigin, TargetOrigin, ret ) == target)
		return true
	
	if ( get_distance_f(TargetOrigin,ret) < 10.0)
		return true
	
	return false
	
}
/* ==================================================================================================== */

public item_dagon(id)
{
	if (player_b_dagfired[id])
	{
		set_hudmessage(220, 30, 30, -1.0, 0.40, 0, 3.0, 2.0, 0.2, 0.3, 5)
		show_hudmessage(id, "You can only use this item once a turn") 
		return PLUGIN_HANDLED
	}
	//Target nearest non-friendly player
	new target = UTIL_FindNearestOpponent(id,600+player_intelligence[id]*20)
	
	if (target == -1) 
		return PLUGIN_HANDLED
	
	new DagonDamage = 0
	new Red = 0
	
	if (player_b_dagon[id] == 1)
	{
		DagonDamage = 20
		Red = 175
	}
	else if (player_b_dagon[id] == 2)
	{
		DagonDamage = 35
		Red = 225
	}
	else if (player_b_dagon[id] == 3)
	{
		DagonDamage = 50
		Red = 255
	}
	
	//Dagon damage done is reduced by the targets dextery
	DagonDamage-=player_dextery[target]*2
	
	if (DagonDamage < 0)
		DagonDamage = 0
	
	
	new Hit[3]
	get_user_origin(target,Hit)
	
	//Create Lightning
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(1) // TE_BEAMENTPOINT
	write_short(id)
	write_coord(Hit[0])
	write_coord(Hit[1])
	write_coord(Hit[2])
	write_short(sprite_lgt)
	write_byte(0)
	write_byte(1)
	write_byte(3)
	write_byte(10)	//WITD
	write_byte(60)
	write_byte(Red)
	write_byte(0)
	write_byte(0)
	write_byte(100)	//BRIGT
	write_byte(0)
	message_end()
	
	player_b_dagfired[id] = true
	
	//Apply damage
	if (get_user_health(target) - DagonDamage <= 0)
		UTIL_Kill(id,target,"world")
	else
	{
		set_user_health(target,get_user_health(target)-DagonDamage)
		Display_Fade(target,2600,2600,0,255,0,0,15)
		hudmsg(id,2.0,"Your dagon hits %i, %i absorbed", DagonDamage, player_dextery[target]*2)
	}
	
	
	return PLUGIN_HANDLED
	
	
}

/* ==================================================================================================== */

public UTIL_Kill(attacker,id,weapon[])
{
	
	if(get_user_team(attacker)!=get_user_team(id))
		set_user_frags(attacker,get_user_frags(attacker) +1);
	if(get_user_team(attacker)==get_user_team(id))
		set_user_frags(attacker,get_user_frags(attacker) -1);
		
	if (cs_get_user_money(attacker) + 150 <= 16000)
		cs_set_user_money(attacker,cs_get_user_money(attacker)+150)
	else
		cs_set_user_money(attacker,16000)
	
	award_kill(attacker,id)
	user_kill(id,1) 
	message_begin( MSG_ALL, gmsgDeathMsg,{0,0,0},0) 
	write_byte(attacker) 
	write_byte(id) 
	write_byte(0) 
	write_string(weapon) 
	message_end() 
	
	message_begin(MSG_ALL,gmsgScoreInfo) 
	write_byte(attacker) 
	write_short(get_user_frags(attacker)) 
	write_short(get_user_deaths(attacker)) 
	write_short(0) 
	write_short(get_user_team(attacker)) 
	message_end() 
	
	message_begin(MSG_ALL,gmsgScoreInfo) 
	write_byte(id) 
	write_short(get_user_frags(id)) 
	write_short(get_user_deaths(id)) 
	write_short(0) 
	write_short(get_user_team(id)) 
	message_end() 
	
	new kname[32], vname[32], kauthid[32], vauthid[32], kteam[10], vteam[10];
	
	get_user_name(attacker, kname, 31);
	get_user_team(attacker, kteam, 9);
	get_user_authid(attacker, kauthid, 31);
	
	get_user_name(id, vname, 31);
	get_user_team(id, vteam, 9);
	get_user_authid(id, vauthid, 31);
	
	log_message("^"%s<%d><%s><%s>^" killed ^"%s<%d><%s><%s>^" with ^"%s^"", 
	kname, get_user_userid(attacker), kauthid, kteam, 
	vname, get_user_userid(id), vauthid, vteam, weapon);
	
	
}

/* ==================================================================================================== */

//Will return 1 if user has amount of money and then substract
public bool:UTIL_Buyformoney(id,amount)
{
	if (cs_get_user_money(id) >= amount)
	{
		cs_set_user_money(id,cs_get_user_money(id)-amount)
		return true
	}
	else
	{
		hudmsg(id,2.0,"Not enough money")
		return false
	}
	
	return false
}
public buyrune(id)
{
	new text[513] 
	
	format(text, 512, "\ySelect Rune - ^n\w1. Tir [Can boost Dagon to Level III] - \r$7000^n\w2. Vex [Can boost Point Booster] - \r$5000^n\w3. Eth [Can Upgrade Air Booster] \r$6500^n\w4. Ral [Can Upgrade Gold Amplifier] \r$7000^n\w5. Sol [You get an item] \r$5000^n\w6. Zal [You get 50 xp] \r$4500^n\w7. Exit") 
	
	new keys = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)
	show_menu(id, keys, text) 
	return PLUGIN_HANDLED  
} 


public select_rune_menu(id, key) 
{ 
	switch(key) 
	{ 
		case 0: 
		{	
			
			//Tir rune
			if (player_b_dagon[id] > 0 && player_b_dagon[id] < 3)
			{
				if (!UTIL_Buyformoney(id,7000))
					return PLUGIN_HANDLED
				
				player_b_dagon[id]++
				if (player_b_dagon[id] == 2) player_item_name[id] = "Dagon II"
				else if (player_b_dagon[id] == 3) player_item_name[id] = "Dagon III"	
					
				set_hudmessage(100, 200, 55, -1.0, 0.40, 0, 3.0, 2.0, 0.2, 0.3, 5)
				show_hudmessage(id, "Dagon Upgraded")
			}
			
		}
		case 1:
		{
			
			//Vex - Point BOoster
			if (item_boosted[id] == 0 && player_item_id[id] == 51)
			{
				if (!UTIL_Buyformoney(id,5000))
					return PLUGIN_HANDLED
				
				item_boosted[id]++
				player_item_name[id] = "Vitality Booster"
				
				//Reset stas
				SubtractStats(id,player_b_extrastats[id])
				player_b_extrastats[id]+=2
				BoostStats(id,player_b_extrastats[id])
				set_hudmessage(100, 200, 55, -1.0, 0.40, 0, 3.0, 2.0, 0.2, 0.3, 5)
				show_hudmessage(id, "Point Booster Upgraded")
			}
		}
		case 2:
		{
			
			if (item_boosted[id] == 0 && player_item_id[id] == 49)
			{
				if (!UTIL_Buyformoney(id,6500))
					return PLUGIN_HANDLED
				
				item_boosted[id]++
				player_item_name[id] = "Elemental Booster"
				player_b_jumpx[id]++
				set_hudmessage(100, 200, 55, -1.0, 0.40, 0, 3.0, 2.0, 0.2, 0.3, 5)
				show_hudmessage(id, "Air Booster Upgraded")
			}
			
			
		}
		case 3:
		{
			
			if (item_boosted[id] == 0 && player_item_id[id] == 3)
			{
				if (!UTIL_Buyformoney(id,7000))
					return PLUGIN_HANDLED
				
				item_boosted[id]++
				player_item_name[id] = "Diamond Amplifier"
				player_b_damage[id]+=random_num(5,8)
				set_hudmessage(100, 200, 55, -1.0, 0.40, 0, 3.0, 2.0, 0.2, 0.3, 5)
				show_hudmessage(id, "Gold Amplifier Upgraded")
			}
		}
		
		case 4: 
		{	
			if (!UTIL_Buyformoney(id,5000))
				return PLUGIN_HANDLED
			award_item(id,0)
			return PLUGIN_HANDLED
		}
		case 5:
		{
			if (!UTIL_Buyformoney(id,4500))
				return PLUGIN_HANDLED
			Give_Xp(id,50)
			return PLUGIN_HANDLED
		}
		
		case 6: 
		{	
			return PLUGIN_HANDLED
		}
	}
	
	return PLUGIN_HANDLED
}

/* ==================================================================================================== */

//Blocks fullupdate (can reset hud)
public fullupdate(id) 
{
	return PLUGIN_HANDLED
}

/* ==================================================================================================== */

public add_bonus_scoutdamage(attacker_id,id,weapon)
{
	if (player_b_sniper[attacker_id] > 0 && get_user_team(attacker_id) != get_user_team(id) && weapon == CSW_SCOUT)
	{
		
		if (!is_user_alive(id))
			return PLUGIN_HANDLED
		
		if (random_num(1,player_b_sniper[attacker_id]) == 1)
			UTIL_Kill(attacker_id,id,"scout")
		
	}
	
	return PLUGIN_HANDLED
}

/* ==================================================================================================== */

public add_bonus_illusion(attacker_id,id,weapon)
{
	if(HasFlag(id,Flag_Illusion))
	{
		new weaponname[32]
		get_weaponname( weapon, weaponname, 31 ) 
		replace(weaponname, 31, "weapon_", "")
		UTIL_Kill(attacker_id,id,weaponname)
	}
}

/* ==================================================================================================== */

public item_take_damage(id,damage)
{
	new itemdamage = get_cvar_num("diablo_durability")
	
	if (player_item_id[id] > 0 && item_durability[id] > 0 && itemdamage> 0 && damage > 5)
	{
		//Make item take damage
		if (item_durability[id] - itemdamage <= 0)
		{
			item_durability[id]-=itemdamage
			dropitem(id)
		}
		else
		{
			item_durability[id]-=itemdamage
		}
		
	}
}

/* ==================================================================================================== */

//From twistedeuphoria plugin
public Prethink_Doublejump(id)
{
	if(!is_user_alive(id)) 
		return PLUGIN_HANDLED
	
	if((get_user_button(id) & IN_JUMP) && !(get_entity_flags(id) & FL_ONGROUND) && !(get_user_oldbutton(id) & IN_JUMP))
	{
		if(jumps[id] < player_b_jumpx[id])
		{
			dojump[id] = true
			jumps[id]++
			return PLUGIN_HANDLED
		}
	}
	if((get_user_button(id) & IN_JUMP) && (get_entity_flags(id) & FL_ONGROUND))
	{
		jumps[id] = 0
		return PLUGIN_CONTINUE
	}
	
	return PLUGIN_HANDLED
}

public Postthink_Doubeljump(id)
{
	if(!is_user_alive(id)) 
		return PLUGIN_HANDLED
	
	if(dojump[id] == true)
	{
		new Float:velocity[3]	
		entity_get_vector(id,EV_VEC_velocity,velocity)
		velocity[2] = random_float(265.0,285.0)
		entity_set_vector(id,EV_VEC_velocity,velocity)
		dojump[id] = false
		return PLUGIN_CONTINUE
	}
	
	return PLUGIN_HANDLED
}

/* ==================================================================================================== */

public spawn_powerup(Float:sOrigin[3])
{
	new ent = create_entity("info_target") 
	entity_set_string(ent, EV_SZ_classname, "PowerUp") 
	entity_set_int(ent, EV_INT_movetype, MOVETYPE_TOSS) 
	entity_set_int(ent, EV_INT_solid, SOLID_BBOX) 
	entity_set_model(ent, "models/bag.mdl")  			
	set_rendering(ent, kRenderFxGlowShell, 0,0,0, kRenderNormal, 255)
	entity_set_origin(ent,sOrigin)
	entity_set_int(ent,EV_INT_iuser1,0)	//Amount of color glow
	new Float:maxs[3] = {16.0,16.0,6.0} 
	new Float:mins[3] = {-16.0,-16.0,-6.0} 
	entity_set_size(ent,mins,maxs) 
	powerup_taken = false
	entity_set_float(ent,EV_FL_nextthink,halflife_time() + 0.01) 
	
}

public award_powerup(id)
{
	if (is_user_connected(id) && is_user_alive(id) && !powerup_taken)
	{
		if (random_num(1,2) == 1)
		{
			if (cs_get_user_money(id) < 5000)
				cs_set_user_money(id,5000)
			else if (cs_get_user_money(id) < 10000)
				cs_set_user_money(id,10000)
			else if (cs_get_user_money(id) < 16000)
				cs_set_user_money(id,16000)
			
			set_hudmessage(100, 200, 55, -1.0, 0.40, 0, 3.0, 2.0, 0.2, 0.3, 5)
			show_hudmessage(id, "Powerup: Money Boost")
		}
		else
		{
			Give_Xp(id,get_cvar_num("diablo_xpbonus")*2)
			set_hudmessage(100, 200, 55, -1.0, 0.40, 0, 3.0, 2.0, 0.2, 0.3, 5)
			show_hudmessage(id, "Powerup: Experience")
		}
		
		powerup_taken = true
	}
}

public Think_PowerUp(ent)
{
	//If set to delete
	if (entity_get_int(ent,EV_INT_iuser2) == 1)
	{
		remove_entity(ent)
		return PLUGIN_HANDLED
	}
	
	new glow = entity_get_int(ent,EV_INT_iuser1)
	
	if (glow < 255)
	{
		glow++
		entity_set_int(ent,EV_INT_iuser1,glow)
	}
	
	set_rendering(ent, kRenderFxGlowShell, 0,glow,0, kRenderNormal, 255)
	entity_set_float(ent,EV_FL_nextthink,halflife_time() + 0.5) 
	
	return PLUGIN_CONTINUE
}

/* ==================================================================================================== */

public register_place(kid)
{
	if (!spawnset)
		return PLUGIN_HANDLED
	
	new Place[3]
	get_user_origin(kid,Place,0)
	
	new distCTstart = get_distance(Place,CTstart) 
	new distTstart = get_distance(Place,Tstart)
	
	if (distCTstart > 300 && distTstart > 300 && abs(distCTstart - distTstart) < 150)
	{
		if (havespawn)
		{
			if (random_num(1,3) == 3)
				NextPowerup = Place
		}
		else
		{
			havespawn = true
			NextPowerup = Place
		}
		
	}
	
	return PLUGIN_CONTINUE
	
	
}

/* ==================================================================================================== */

public SpawnPowerup()
{
	if (!spawnset || !havespawn)
		return PLUGIN_HANDLED
	
	new chance = get_cvar_num("diablo_spawnchance")
	
	if (random_num(1,chance) == 1)
	{	
		
		//Dont spawn if one is already there
		if (find_ent_by_class(-1,"PowerUp") > 0)
			return PLUGIN_HANDLED
		
		//Spawn powerup
		new Float:spawnplace[3]
		IVecFVec(NextPowerup,spawnplace)
		spawn_powerup(spawnplace)
	}
	
	return PLUGIN_CONTINUE
	
	
}

/* ==================================================================================================== */

public eventGrenade(id) 
{
	new id = read_data(1)
	if (player_b_grenade[id] > 0 || player_b_smokehit[id] > 0)
	{
		set_task(0.1, "makeGlow", id)
	}
}

public makeGlow(id) 
{
	new grenade
	new greModel[100]
	grenade = get_grenade(id) 
	
	if( grenade ) 
	{	
		entity_get_string(grenade, EV_SZ_model, greModel, 99)
		
		if(equali(greModel, "models/w_hegrenade.mdl" ) && player_b_grenade[id] > 0 )	
			set_rendering(grenade, kRenderFxGlowShell, 255,0,0, kRenderNormal, 255)
		
		if(equali(greModel, "models/w_smokegrenade.mdl" ) && player_b_smokehit[id] > 0 )	
		{
			set_rendering(grenade, kRenderFxGlowShell, 0,255,255, kRenderNormal, 255)
		}
	}
}

/* ==================================================================================================== */

public BoostStats(id,amount)
{
	player_strength[id]+=amount
	player_dextery[id]+=amount
	player_agility[id]+=amount
	player_intelligence[id]+=amount
}

public SubtractStats(id,amount)
{
	player_strength[id]-=amount
	player_dextery[id]-=amount
	player_agility[id]-=amount
	player_intelligence[id]-=amount
}

/* ==================================================================================================== */

public SelectBotRace(id)
{
	if (!is_user_bot(id))
		return PLUGIN_HANDLED
	
	if (player_class[id] == 0)
		player_class[id] = random_num(1,5)
	
	return PLUGIN_CONTINUE
}

/* ==================================================================================================== */

public showskills(id)
{
	new Skillsinfo[768]
	format(Skillsinfo,767,"You have %i strength - this give you %i extra hitpoints<br><br>You have %i Dextery - this give a speed boost of %i% and reduce magic damage taken with %i%%<br><br>You have %i Agility - Helps to find unique items and reduce damage from normal attacks by %0.0f%%<br><br>You have %i intelligence - this will make the USE items more efficient<br>",
	player_strength[id],
	player_strength[id]*2,
	player_dextery[id],
	player_dextery[id],
	player_dextery[id]*3,
	player_agility[id],
	player_damreduction[id]*100,
	player_intelligence[id])
	
	showitem(id,"Skills","None","None", Skillsinfo)
}

/* ==================================================================================================== */

public UTIL_Teleport(id,distance)
{	
	Set_Origin_Forward(id,distance)
	
	new origin[3]
	get_user_origin(id,origin)
	
	//Particle burst ie. teleport effect	
	message_begin(MSG_BROADCAST ,SVC_TEMPENTITY) //message begin
	write_byte(TE_PARTICLEBURST )
	write_coord(origin[0]) // origin
	write_coord(origin[1]) // origin
	write_coord(origin[2]) // origin
	write_short(20) // radius
	write_byte(1) // particle color
	write_byte(4) // duration * 10 will be randomized a bit
	message_end()
	
	
}

stock Set_Origin_Forward(id, distance) 
{
	new Float:origin[3]
	new Float:angles[3]
	new Float:teleport[3]
	new Float:heightplus = 10.0
	new Float:playerheight = 64.0
	new bool:recalculate = false
	new bool:foundheight = false
	pev(id,pev_origin,origin)
	pev(id,pev_angles,angles)
	
	teleport[0] = origin[0] + distance * floatcos(angles[1],degrees) * floatabs(floatcos(angles[0],degrees));
	teleport[1] = origin[1] + distance * floatsin(angles[1],degrees) * floatabs(floatcos(angles[0],degrees));
	teleport[2] = origin[2]+heightplus
	
	while (!Can_Trace_Line_Origin(origin,teleport) || Is_Point_Stuck(teleport,48.0))
	{	
		if (distance < 10)
			break;
		
		//First see if we can raise the height to MAX playerheight, if we can, it's a hill and we can teleport there	
		for (new i=1; i < playerheight+20.0; i++)
		{
			teleport[2]+=i
			if (Can_Trace_Line_Origin(origin,teleport) && !Is_Point_Stuck(teleport,48.0))
			{
				foundheight = true
				heightplus += i
				break
			}
			
			teleport[2]-=i
		}
		
		if (foundheight)
			break
		
		recalculate = true
		distance-=10
		teleport[0] = origin[0] + (distance+32) * floatcos(angles[1],degrees) * floatabs(floatcos(angles[0],degrees));
		teleport[1] = origin[1] + (distance+32) * floatsin(angles[1],degrees) * floatabs(floatcos(angles[0],degrees));
		teleport[2] = origin[2]+heightplus
	}
	
	if (!recalculate)
	{
		set_pev(id,pev_origin,teleport)
		return PLUGIN_CONTINUE
	}
	
	teleport[0] = origin[0] + distance * floatcos(angles[1],degrees) * floatabs(floatcos(angles[0],degrees));
	teleport[1] = origin[1] + distance * floatsin(angles[1],degrees) * floatabs(floatcos(angles[0],degrees));
	teleport[2] = origin[2]+heightplus
	set_pev(id,pev_origin,teleport)
	
	return PLUGIN_CONTINUE
}

stock bool:Can_Trace_Line_Origin(Float:origin1[3], Float:origin2[3])
{	
	new Float:Origin_Return[3]	
	new Float:temp1[3]
	new Float:temp2[3]
	
	temp1[x] = origin1[x]
	temp1[y] = origin1[y]
	temp1[z] = origin1[z]-30
	
	temp2[x] = origin2[x]
	temp2[y] = origin2[y]
	temp2[z] = origin2[z]-30
	
	trace_line(-1, temp1, temp2, Origin_Return) 
	
	if (get_distance_f(Origin_Return,temp2) < 1.0)
		return true
	
	return false
}

stock bool:Is_Point_Stuck(Float:Origin[3], Float:hullsize)
{
	new Float:temp[3]
	new Float:iterator = hullsize/3
	
	temp[2] = Origin[2]
	
	for (new Float:i=Origin[0]-hullsize; i < Origin[0]+hullsize; i+=iterator)
	{
		for (new Float:j=Origin[1]-hullsize; j < Origin[1]+hullsize; j+=iterator)
		{
			//72 mod 6 = 0
			for (new Float:k=Origin[2]-CS_PLAYER_HEIGHT; k < Origin[2]+CS_PLAYER_HEIGHT; k+=6) 
			{
				temp[0] = i
				temp[1] = j
				temp[2] = k
				
				if (point_contents(temp) != -1)
					return true
			}
		}
	}
	
	return false
}

stock Effect_Bleed(id,color)
{
	new origin[3]
	get_user_origin(id,origin)
	
	new dx, dy, dz
	
	for(new i = 0; i < 3; i++) 
	{
		dx = random_num(-15,15)
		dy = random_num(-15,15)
		dz = random_num(-20,25)
		
		for(new j = 0; j < 2; j++) 
		{
			message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
			write_byte(TE_BLOODSPRITE)
			write_coord(origin[0]+(dx*j))
			write_coord(origin[1]+(dy*j))
			write_coord(origin[2]+(dz*j))
			write_short(sprite_blood_spray)
			write_short(sprite_blood_drop)
			write_byte(color) // color index
			write_byte(8) // size
			message_end()
		}
	}
}

/* ==================================================================================================== */

public Use_Spell(id)
{
	if (player_global_cooldown[id] + GLOBAL_COOLDOWN >= halflife_time())
		return PLUGIN_CONTINUE
	else
		player_global_cooldown[id] = halflife_time()
		
	if (!is_user_alive(id) || !freeze_ended)
		return PLUGIN_CONTINUE
	
	/*See if USE button is used for anything else..
	1) Close to bomb
	2) Close to hostage
	3) Close to switch
	4) Close to door
	*/
	
	new Float:origin[3]
	pev(id, pev_origin, origin)
	
	//Func door and func door rotating
	new aimid, body
	get_user_aiming ( id, aimid, body ) 
	
	if (aimid > 0)
	{
		new classname[32]
		pev(aimid,pev_classname,classname,31)
		
		if (equal(classname,"func_door_rotating") || equal(classname,"func_door") || equal(classname,"func_button"))
		{
			new Float:doororigin[3]
			pev(aimid, pev_origin, doororigin)
			
			if (get_distance_f(origin, doororigin) < 70 && UTIL_In_FOV(id,aimid))
				return PLUGIN_CONTINUE
		}
		
	}
	
	//Bomb condition
	new bomb
	if ((bomb = find_ent_by_model(-1, "grenade", "models/w_c4.mdl"))) 
	{
		new Float:bombpos[3]
		pev(bomb, pev_origin, bombpos)
			
		//We are near the bomb and have it in FOV.
		if (get_distance_f(origin, bombpos) < 100 && UTIL_In_FOV(id,bomb))
			return PLUGIN_CONTINUE
	}

	
	//Hostage
	new hostage = engfunc(EngFunc_FindEntityByString, -1,"classname", "hostage_entity")
	
	while (hostage)
	{
		new Float:hospos[3]
		pev(hostage, pev_origin, hospos)
		if (get_distance_f(origin, hospos) < 70 && UTIL_In_FOV(id,hostage))
			return PLUGIN_CONTINUE
		
		hostage = engfunc(EngFunc_FindEntityByString, hostage,"classname", "hostage_entity")
	}
	
	check_magic(id)
	
	
	return PLUGIN_CONTINUE
}

/* ==================================================================================================== */

//Angle to all targets in fov
stock Float:Find_Angle(Core,Target,Float:dist)
{
	new Float:vec2LOS[2]
	new Float:flDot	
	new Float:CoreOrigin[3]
	new Float:TargetOrigin[3]
	new Float:CoreAngles[3]
	
	pev(Core,pev_origin,CoreOrigin)
	pev(Target,pev_origin,TargetOrigin)
	
	if (get_distance_f(CoreOrigin,TargetOrigin) > dist)
		return 0.0
	
	pev(Core,pev_angles, CoreAngles)
	
	for ( new i = 0; i < 2; i++ )
		vec2LOS[i] = TargetOrigin[i] - CoreOrigin[i]
	
	new Float:veclength = Vec2DLength(vec2LOS)
	
	//Normalize V2LOS
	if (veclength <= 0.0)
	{
		vec2LOS[x] = 0.0
		vec2LOS[y] = 0.0
	}
	else
	{
		new Float:flLen = 1.0 / veclength;
		vec2LOS[x] = vec2LOS[x]*flLen
		vec2LOS[y] = vec2LOS[y]*flLen
	}
	
	//Do a makevector to make v_forward right
	engfunc(EngFunc_MakeVectors,CoreAngles)
	
	new Float:v_forward[3]
	new Float:v_forward2D[2]
	get_global_vector(GL_v_forward, v_forward)
	
	v_forward2D[x] = v_forward[x]
	v_forward2D[y] = v_forward[y]
	
	flDot = vec2LOS[x]*v_forward2D[x]+vec2LOS[y]*v_forward2D[y]
	
	if ( flDot > 0.5 )
	{
		return flDot
	}
	
	return 0.0	
}

stock Float:Vec2DLength( Float:Vec[2] )  
{ 
	return floatsqroot(Vec[x]*Vec[x] + Vec[y]*Vec[y] )
}

stock bool:UTIL_In_FOV(id,target)
{
	if (Find_Angle(id,target,9999.9) > 0.0)
		return true
	
	return false
}

/* ==================================================================================================== */

public Greet_Player(id)
{
	id-=TASK_GREET
	new name[32]
	get_user_name(id,name,31)
	client_print(id,print_chat, "Welcome %s to Diablo Mod v. %00.0f Say /help for help how to play", name, version)
}

/* ==================================================================================================== */

stock Display_Fade(id,duration,holdtime,fadetype,red,green,blue,alpha)
{
	message_begin( MSG_ONE,get_user_msgid("ScreenFade"),{0,0,0},id )
	write_short( duration )	// Duration of fadeout
	write_short( holdtime )	// Hold time of color
	write_short( fadetype )	// Fade type
	write_byte ( red )		// Red
	write_byte ( green )		// Green
	write_byte ( blue )		// Blue
	write_byte ( alpha )	// Alpha
	message_end()
}

/* ==================================================================================================== */

public changerace(id)
{
	set_user_health(id,0)
	if (player_item_id[id] != 0) 
	{ 
		dropitem(id)
	} 

	client_connect(id)
	select_class(id)
}

/* ==================================================================================================== */

//Disable autohelp messages and display our own.
public FW_WriteString(string[])
{
	if (equal(string,""))
		return FMRES_IGNORED
	
	//Disable autohelp
	if (equal(string,"#Hint_press_buy_to_purchase") || equal(string,"#Hint_press_buy_to_purchase "))
	{
		write_string( "" );
		return FMRES_SUPERCEDE
	}
	
	if (equal(string, "#Hint_spotted_a_friend") || equal(string, "#Hint_you_have_the_bomb"))
	{
		write_string( "" );
		return FMRES_SUPERCEDE
	}
	
	return FMRES_IGNORED
	
}

stock hudmsg(id,Float:display_time,const fmt[], {Float,Sql,Result,_}:...)
{	
	if (player_huddelay[id] >= 0.03*4)
		return PLUGIN_CONTINUE
	
	new buffer[512]
	vformat(buffer, 511, fmt, 4)
	
	set_hudmessage ( 255, 0, 0, -1.0, 0.4 + player_huddelay[id], 0, display_time/2, display_time, 0.1, 0.2, -1 ) 	
	show_hudmessage(id, buffer)
	
	player_huddelay[id]+=0.03
	
	remove_task(id+TASK_HUD)
	set_task(display_time, "hudmsg_clear", id+TASK_HUD, "", 0, "a", 3)
	
	
	return PLUGIN_CONTINUE
	
}

public hudmsg_clear(id)
{
	new pid = id-TASK_HUD
	player_huddelay[pid]=0.0
}

/* ==================================================================================================== */

public item_firetotem(id)
{
	if (used_item[id])
	{
		hudmsg(id,2.0,"You can only use the fire totem each time a round")
	}
	else
	{
		used_item[id] = true
		Effect_Ignite_Totem(id,7)
	}
}

stock Effect_Ignite_Totem(id,seconds)
{
	new origin[3]
	pev(id,pev_origin,origin)
	
	new ent = Spawn_Ent("info_target")
	set_pev(ent,pev_classname,"Effect_Ignite_Totem")
	set_pev(ent,pev_owner,id)
	set_pev(ent,pev_solid,SOLID_TRIGGER)
	set_pev(ent,pev_origin,origin)
	set_pev(ent,pev_ltime, halflife_time() + seconds + 0.1)
	
	engfunc(EngFunc_SetModel, ent, "addons/amxmodx/diablo/totem_ignite.mdl")  	
	set_rendering ( ent, kRenderFxGlowShell, 250,150,0, kRenderFxNone, 255 ) 	
	engfunc(EngFunc_DropToFloor,ent)
	
	set_pev(ent,pev_euser3,0)
	set_pev(ent,pev_nextthink, halflife_time() + 0.1)
}

public Effect_Ignite_Totem_Think(ent)
{
	//Safe check because effect on death
	if (!freeze_ended)
		remove_entity(ent)
	
	if (!is_valid_ent(ent))
		return PLUGIN_CONTINUE
	
	new id = pev(ent,pev_owner)
	
	//Apply and destroy
	if (pev(ent,pev_euser3) == 1)
	{
		new entlist[513]
		new numfound = find_sphere_class(ent,"player",player_b_firetotem[id]+0.0,entlist,512)
		
		for (new i=0; i < numfound; i++)
		{		
			new pid = entlist[i]
			
			//This totem can hit the caster
			if (pid == id && is_user_alive(id))
			{
				Effect_Ignite(pid,id,4)
				hudmsg(pid,3.0,"You are burning. Damage someone to make the fire stop!")
				continue
			}
			
			if (!is_user_alive(pid) || get_user_team(id) == get_user_team(pid))
				continue
			
			//Dextery makes the fire damage less
			if (player_dextery[pid] > 20)
				Effect_Ignite(pid,id,1)
			else if (player_dextery[pid] > 15)
				Effect_Ignite(pid,id,2)
			else if (player_dextery[pid] > 10)
				Effect_Ignite(pid,id,3)
			else
				Effect_Ignite(pid,id,4)
			
			hudmsg(pid,3.0,"You are burning. Damage someone to make the fire stop!")
		}
		
		remove_entity(ent)
		return PLUGIN_CONTINUE
	}
	
	
	
	//Entity should be destroyed because livetime is over
	if (pev(ent,pev_ltime) < halflife_time())
	{
		set_pev(ent,pev_euser3,1)
		
		//Show animation and die
		
		new Float:forigin[3], origin[3]
		pev(ent,pev_origin,forigin)	
		FVecIVec(forigin,origin)
		
		//Find people near and give them health
		message_begin( MSG_BROADCAST, SVC_TEMPENTITY, origin );
		write_byte( TE_BEAMCYLINDER );
		write_coord( origin[0] );
		write_coord( origin[1] );
		write_coord( origin[2] );
		write_coord( origin[0] );
		write_coord( origin[1] + player_b_firetotem[id]);
		write_coord( origin[2] + player_b_firetotem[id]);
		write_short( sprite_white );
		write_byte( 0 ); // startframe
		write_byte( 0 ); // framerate
		write_byte( 10 ); // life
		write_byte( 10 ); // width
		write_byte( 255 ); // noise
		write_byte( 150 ); // r, g, b
		write_byte( 150 ); // r, g, b
		write_byte( 0 ); // r, g, b
		write_byte( 128 ); // brightness
		write_byte( 5 ); // speed
		message_end();
		
		set_pev(ent,pev_nextthink, halflife_time() + 0.2)
		
	}
	else	
	{
		set_pev(ent,pev_nextthink, halflife_time() + 1.5)
	}
	
	return PLUGIN_CONTINUE
}

stock Spawn_Ent(const classname[]) 
{
	new ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, classname))
	set_pev(ent, pev_origin, {0.0, 0.0, 0.0})    
	dllfunc(DLLFunc_Spawn, ent)
	return ent
}

stock Effect_Ignite(id,attacker,damage)
{
	new ent = Spawn_Ent("info_target")
	set_pev(ent,pev_classname,"Effect_Ignite")
	set_pev(ent,pev_owner,id)
	set_pev(ent,pev_ltime, halflife_time() + 99 + 0.1)
	set_pev(ent,pev_solid,SOLID_NOT)
	set_pev(ent,pev_euser1,attacker)
	set_pev(ent,pev_euser2,damage)
	set_pev(ent,pev_nextthink, halflife_time() + 0.1)	
	
	AddFlag(id,Flag_Ignite)
}

//euser3 = destroy and apply effect
public Effect_Ignite_Think(ent)
{
	new id = pev(ent,pev_owner)
	new attacker = pev(ent,pev_euser1)
	new damage = pev(ent,pev_euser2)
	
	if (pev(ent,pev_ltime) < halflife_time() || !is_user_alive(id) || !HasFlag(id,Flag_Ignite))
	{
		RemoveFlag(id,Flag_Ignite)
		Remove_All_Tents(id)
		Display_Icon(id,200,0,0,"dmg_heat",0)
		remove_entity(ent)		
		return PLUGIN_CONTINUE
	}
	
	
	//Display ignite tent and icon
	Display_Tent(id,sprite_ignite,2)
	Display_Icon(id,200,0,0,"dmg_heat",1)
	
	new origin[3]
	get_user_origin(id,origin)
	
	//Make some burning effects
	message_begin( MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte( TE_SMOKE ) // 5
	write_coord(origin[0])
	write_coord(origin[1])
	write_coord(origin[2])
	write_short( sprite_smoke )
	write_byte( 22 )  // 10
	write_byte( 10 )  // 10
	message_end()
	
	//Decals
	message_begin( MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte( TE_GUNSHOTDECAL ) // decal and ricochet sound
	write_coord( origin[0] ) //pos
	write_coord( origin[1] )
	write_coord( origin[2] )
	write_short (0) // I have no idea what thats supposed to be
	write_byte (random_num(199,201)) //decal
	message_end()
	
	
	//Do the actual damage
	Hurt_Entity(attacker,id,damage+0.0)
	
	set_pev(ent,pev_nextthink, halflife_time() + 1.5)
	
	
	return PLUGIN_CONTINUE
}

stock AddFlag(id,flag)
{
	afflicted[id][flag] = 1	
}

stock RemoveFlag(id,flag)
{
	afflicted[id][flag] = 0
}

stock bool:HasFlag(id,flag)
{
	if (afflicted[id][flag])
		return true
	
	return false
}

stock Display_Tent(id,sprite, seconds)
{
	message_begin(MSG_ALL,SVC_TEMPENTITY)
	write_byte(TE_PLAYERATTACHMENT)
	write_byte(id)
	write_coord(40) //Offset
	write_short(sprite)
	write_short(seconds*10)
	message_end()
}

stock Remove_All_Tents(id)
{
	message_begin(MSG_ALL ,SVC_TEMPENTITY) //message begin
	write_byte(TE_KILLPLAYERATTACHMENTS)
	write_byte(id) // entity index of player
	message_end()
}

stock Display_Icon(id,red,green,blue,name[], enable)
{
	if (!pev_valid(id))
	{
		return PLUGIN_HANDLED
	}
	
	message_begin( MSG_ONE, get_user_msgid("StatusIcon"), {0,0,0}, id ) 
	write_byte( enable ) 	
	write_string( name ) 
	write_byte( red ) // red 
	write_byte( green ) // green 
	write_byte( blue ) // blue 
	message_end()
	
	return PLUGIN_CONTINUE
}

stock Hurt_Entity(attacker,victim,Float:amount)
{
	if (get_user_health(victim)-amount <= 1)
	{
		UTIL_Kill(attacker,victim,"world")
	}
	else
	{
		fakedamage(victim,"player",amount,DMG_ENERGYBEAM)
	}
}

stock Find_Best_Angle(id,Float:dist, same_team = false)
{
	new Float:bestangle = 0.0
	new winner = -1
	
	for (new i=0; i < MAX; i++)
	{
		if (!is_user_alive(i) || i == id || (get_user_team(i) == get_user_team(id) && !same_team))
			continue
		
		if (get_user_team(i) != get_user_team(id) && same_team)
			continue
		
		//User has spell immunity, don't target
		
		new Float:c_angle = Find_Angle(id,i,dist)
		
		if (c_angle > bestangle && Can_Trace_Line(id,i))
		{
			winner = i
			bestangle = c_angle
		}
		
	}
	
	return winner
}

//This is an interpolation. We make tree lines with different height as to make sure
stock bool:Can_Trace_Line(id, target)
{	
	for (new i=-35; i < 60; i+=35)
	{		
		new Float:Origin_Id[3]
		new Float:Origin_Target[3]
		new Float:Origin_Return[3]
		
		pev(id,pev_origin,Origin_Id)
		pev(target,pev_origin,Origin_Target)
		
		Origin_Id[z] = Origin_Id[z] + i
		Origin_Target[z] = Origin_Target[z] + i
		
		trace_line(-1, Origin_Id, Origin_Target, Origin_Return) 
		
		if (get_distance_f(Origin_Return,Origin_Target) < 25.0)
			return true
		
	}
	
	return false
}

public item_hook(id)
{
	if (used_item[id])
	{
		hudmsg(id,2.0,"You can only use the hook one time each round")
		return PLUGIN_CONTINUE	
	}
	
	new target = Find_Best_Angle(id,1000.0,false)
	
	if (!is_valid_ent(target))
	{
		hudmsg(id,2.0,"No targets in range to hook")
		return PLUGIN_CONTINUE
	}
	
	AddFlag(id,Flag_Hooking)
	
	set_user_gravity(target,0.0)
	set_task(0.1,"hook_prethink",id+TASK_HOOK,"",0,"b")
	hooked[id] = target
	hook_prethink(id+TASK_HOOK)
	emit_sound(id,CHAN_VOICE,"weapons/xbow_hit2.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	
	used_item[id] = true	
	return PLUGIN_HANDLED
	
}

public hook_prethink(id)
{
	id -= TASK_HOOK
	if(!is_user_alive(id) || !is_user_alive(hooked[id])) 
	{
		RemoveFlag(id,Flag_Hooking)
		return PLUGIN_HANDLED
	}
	if (get_user_button(id) & ~IN_USE)
	{
		RemoveFlag(id,Flag_Hooking)
		return PLUGIN_HANDLED	
	}
	if(!HasFlag(id,Flag_Hooking))
	{
		if (is_user_alive(hooked[id]))
			set_user_gravity(id,1.0)
		remove_task(id+TASK_HOOK)
		return PLUGIN_HANDLED
	}
	
	//Get Id's origin
	static origin1[3]
	get_user_origin(id,origin1)
	
	static origin2[3]
	get_user_origin(hooked[id],origin2)
	
	//Create blue beam
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte(1)		//TE_BEAMENTPOINT
	write_short(id)		// start entity
	write_coord(origin2[0])
	write_coord(origin2[1])
	write_coord(origin2[2])
	write_short(sprite_line)
	write_byte(1)		// framestart
	write_byte(1)		// framerate
	write_byte(2)		// life in 0.1's
	write_byte(5)		// width
	write_byte(0)		// noise
	write_byte(0)		// red
	write_byte(0)		// green
	write_byte(255)		// blue
	write_byte(200)		// brightness
	write_byte(0)		// speed
	message_end()
	
	//Calculate Velocity
	new Float:velocity[3]
	velocity[0] = (float(origin1[0]) - float(origin2[0])) * 3.0
	velocity[1] = (float(origin1[1]) - float(origin2[1])) * 3.0
	velocity[2] = (float(origin1[2]) - float(origin2[2])) * 3.0
	
	new Float:dy
	dy = velocity[0]*velocity[0] + velocity[1]*velocity[1] + velocity[2]*velocity[2]
	
	new Float:dx
	dx = (4+player_intelligence[id]/2) * 120.0 / floatsqroot(dy)
	
	velocity[0] *= dx
	velocity[1] *= dx
	velocity[2] *= dx
	
	set_pev(hooked[id],pev_velocity,velocity)
	
	return PLUGIN_CONTINUE
}

/* ==================================================================================================== */

public item_gravitybomb(id)
{	
	if (pev(id,pev_flags) & FL_ONGROUND) 
	{
		hudmsg(id,2.0,"You have to be in the air to earth stomp")
		return PLUGIN_CONTINUE
	}
	
	if (halflife_time()-gravitytimer[id] <= 3)
	{
		hudmsg(id,2.0,"This ability can only be used every 3 seconds")
		return PLUGIN_CONTINUE
	}
	
	gravitytimer[id] = floatround(halflife_time())
	
	new origin[3]
	get_user_origin(id,origin)
	
	if (origin[2] == 0)
		earthstomp[id] = 1
	else
		earthstomp[id] = origin[2]
	
	set_user_gravity(id,5.0)
	falling[id] = true
	
		
	return PLUGIN_CONTINUE
	
}

public add_bonus_stomp(id)
{
	add_gravity_bonus(id)
	
	new origin[3]
	get_user_origin(id,origin)
	
	new dam = earthstomp[id]-origin[2]
	
	earthstomp[id] = 0
	
	//If jump is is high enough, apply some shake effect and deal damage, 300 = down from BOMB A in dust2
	if (dam < 80)
		return PLUGIN_CONTINUE
		
	dam = dam-80
	
	message_begin(MSG_ONE , get_user_msgid("ScreenShake") , {0,0,0} ,id)
	write_short( 1<<14 );
	write_short( 1<<12 );
	write_short( 1<<14 );
	message_end();
		
	new entlist[513]
	new numfound = find_sphere_class(id,"player",230.0+player_strength[id]*2,entlist,512)
	

	for (new i=0; i < numfound; i++)
	{		
		new pid = entlist[i]
			
		if (pid == id || !is_user_alive(pid))
			continue
			
		if (get_user_team(id) == get_user_team(pid))
			continue
			
		new Float:id_origin[3]
		new Float:pid_origin[3]
		new Float:delta_vec[3]
		
		pev(id,pev_origin,id_origin)
		pev(pid,pev_origin,pid_origin)
		
		
		delta_vec[x] = (pid_origin[x]-id_origin[x])+10
		delta_vec[y] = (pid_origin[y]-id_origin[y])+10
		delta_vec[z] = (pid_origin[z]-id_origin[z])+200
		
		set_pev(pid,pev_velocity,delta_vec)
						
		message_begin(MSG_ONE , get_user_msgid("ScreenShake") , {0,0,0} ,pid)
		write_short( 1<<14 );
		write_short( 1<<12 );
		write_short( 1<<14 );
		message_end();
		
		if (get_user_health(pid) - dam <= 0)
			UTIL_Kill(id,pid,"world")
		else
			set_user_health(pid,get_user_health(pid)-dam)
			
				
				
	}
		
	return PLUGIN_CONTINUE
}

/* ==================================================================================================== */

public item_rot(id)
{
	if (used_item[id])
	{
		RemoveFlag(id,Flag_Rot)
		used_item[id] = false
	}
	else
	{
		if (find_ent_by_owner(-1,"Effect_Rot",id) > 0)
			return PLUGIN_CONTINUE
			
		Create_Rot(id)
		used_item[id] = true
	}
	
	return PLUGIN_CONTINUE
}

public Create_Rot(id)
{		
	new ent = Spawn_Ent("info_target")
	set_pev(ent,pev_classname,"Effect_Rot")
	set_pev(ent,pev_owner,id)
	set_pev(ent,pev_solid,SOLID_NOT)
	AddFlag(id,Flag_Rot)
	set_pev(ent,pev_nextthink, halflife_time() + 0.1)	
			
}

public Effect_Rot_Think(ent)
{
	new id = pev(ent,pev_owner)
	if (!is_user_alive(id) || !HasFlag(id,Flag_Rot) || !freeze_ended)
	{
		Display_Icon(id,255,255,0,"dmg_bio",0)	
		set_user_maxspeed(id,245.0+player_dextery[id])
		set_user_rendering(id,kRenderFxGlowShell,0,0,0,kRenderNormal,16)  
		remove_entity(ent)
		return PLUGIN_CONTINUE
	}
	
	set_user_maxspeed(id,252.0+player_dextery[id]+15)
	Display_Icon(id,255,150,0,"dmg_bio",1)	
	set_rendering ( id, kRenderFxGlowShell, 255,255,0, kRenderFxNone, 10 ) 
	
	new entlist[513]
	new numfound = find_sphere_class(id,"player",250.0,entlist,512)
	
	for (new i=0; i < numfound; i++)
	{		
		new pid = entlist[i]
			
		if (pid == id || !is_user_alive(pid))
			continue
			
		if (get_user_team(id) == get_user_team(pid))
			continue
		
		//Rot him!
		if (random_num(1,2) == 1)
		{
			message_begin(MSG_ONE,gmsgFade,{0,0,0},pid)
			write_short( 1<<14 ) 
			write_short( 1<<14 ) 
			write_short( 1<<16 ) 
			write_byte( 255 ) 
			write_byte( 155 ) 
			write_byte( 50 ) 
			write_byte( 230 ) 
			message_end()
		}
		
		Hurt_Entity(id,pid,45.0)
		Effect_Bleed(pid,100)
		Create_Slow(pid,3)
		
	}
	
	if (get_user_health(id)-10 <= 0)
		UTIL_Kill(id,id,"world")
	else
		set_user_health(id,get_user_health(id)-10)
		
	set_pev(ent,pev_nextthink, halflife_time() + 0.8)
	return PLUGIN_CONTINUE
}

/* ==================================================================================================== */

//Daze player
stock Create_Slow(id,seconds)
{		
	new ent = Spawn_Ent("info_target")
	set_pev(ent,pev_classname,"Effect_Slow")
	set_pev(ent,pev_owner,id)
	set_pev(ent,pev_ltime, halflife_time() + seconds + 0.1)
	set_pev(ent,pev_solid,SOLID_NOT)
	set_pev(ent,pev_nextthink, halflife_time() + 0.1)	
			
	AddFlag(id,Flag_Dazed)
}

public Effect_Slow_Think(ent)
{
	new id = pev(ent,pev_owner)
	if (pev(ent,pev_ltime) < halflife_time() || !is_user_alive(id))
	{
		Display_Icon(id,255,255,0,"dmg_heat",0)	
		RemoveFlag(id,Flag_Dazed)
		set_user_maxspeed(id,245.0+player_agility[id])
		remove_entity(ent)
		return PLUGIN_CONTINUE
	}
	
	set_user_maxspeed(id,245.0-50)
	Display_Icon(id,255,255,0,"dmg_heat",1)	
	set_pev(ent,pev_nextthink, halflife_time() + 1.0)
	return PLUGIN_CONTINUE
}

/* ==================================================================================================== */

stock AddTimedFlag(id,flag,seconds)
{		
	new ent = Spawn_Ent("info_target")
	set_pev(ent,pev_classname,"Effect_Timedflag")
	set_pev(ent,pev_owner,id)
	set_pev(ent,pev_ltime, halflife_time() + seconds + 0.1)
	set_pev(ent,pev_solid,SOLID_NOT)
	set_pev(ent,pev_euser3,flag)			
	AddFlag(id,flag)	
	set_pev(ent,pev_nextthink, halflife_time() + 0.1)
}

public Effect_Timedflag_Think(ent)
{
	new id = pev(ent,pev_owner)
	if (pev(ent,pev_ltime) < halflife_time() || !is_user_alive(id))
	{
		RemoveFlag(id,pev(ent,pev_euser3))
		remove_entity(ent)
		return PLUGIN_CONTINUE
	}
	
	set_pev(ent,pev_nextthink, halflife_time() + 1.0)
	return PLUGIN_CONTINUE
}

/* ==================================================================================================== */

public item_illusion(id)
{
	if (used_item[id])
	{
		hudmsg(id,2.0,"You can only use this item one time each round")
		return PLUGIN_CONTINUE
	}

	AddTimedFlag(id,Flag_Illusion,7)
	message_begin( MSG_ONE, gmsgBartimer, {0,0,0}, id ) 
	write_byte( 7) 
	write_byte( 0 ) 
	message_end() 
	used_item[id] = true
	use_addtofullpack = true
	return PLUGIN_CONTINUE
	
}

/* ==================================================================================================== */

public item_money_shield(id)
{
	if (used_item[id])
	{
		RemoveFlag(id,Flag_Moneyshield)
		used_item[id] = false
	}
	else
	{
		if (find_ent_by_owner(-1,"Effect_MShield",id) > 0)
			return PLUGIN_CONTINUE
			
		new ent = Spawn_Ent("info_target")
		set_pev(ent,pev_classname,"Effect_MShield")
		set_pev(ent,pev_owner,id)
		set_pev(ent,pev_solid,SOLID_NOT)		
		AddFlag(id,Flag_Moneyshield)	
		set_pev(ent,pev_nextthink, halflife_time() + 0.1)
		used_item[id] = true
	}
	
	return PLUGIN_CONTINUE
}

public Effect_MShield_Think(ent)
{
	new id = pev(ent,pev_owner)
	if (!is_user_alive(id) || cs_get_user_money(id) <= 0 || !HasFlag(id,Flag_Moneyshield) || !freeze_ended)
	{
		RemoveFlag(id,Flag_Moneyshield)
		set_user_rendering(id,kRenderFxGlowShell,0,0,0,kRenderNormal,16)  
		Display_Icon(id,255,255,255,"suithelmet_empty",0)
		remove_entity(ent)
		return PLUGIN_CONTINUE
	}
	
	if (cs_get_user_money(id)-250 < 0)
		cs_set_user_money(id,0)
	else
		cs_set_user_money(id,cs_get_user_money(id)-250)
		
	set_rendering ( id, kRenderFxGlowShell, 255,255,255, kRenderFxNone, 10 ) 
	Display_Icon(id,255,255,255,"suithelmet_empty",1)
	
	set_pev(ent,pev_nextthink, halflife_time() + 1.0)
	return PLUGIN_CONTINUE
}

/* ==================================================================================================== */

public item_mine(id)
{
	new count = 0
	new ents = -1
	ents = find_ent_by_owner(ents,"Mine",id)
	while (ents > 0)
	{
		count++
		ents = find_ent_by_owner(ents,"Mine",id)
	}
	
	if (count > 2)
	{
		hudmsg(id,2.0,"Maximum 3 mines each round")
		return PLUGIN_CONTINUE
	}
	
	
	new origin[3]
	pev(id,pev_origin,origin)
		
	new ent = Spawn_Ent("info_target")
	set_pev(ent,pev_classname,"Mine")
	set_pev(ent,pev_owner,id)
	set_pev(ent,pev_movetype,MOVETYPE_TOSS)
	set_pev(ent,pev_origin,origin)
	set_pev(ent,pev_solid,SOLID_BBOX)
	
	engfunc(EngFunc_SetModel, ent, "addons/amxmodx/diablo/mine.mdl")  
	engfunc(EngFunc_SetSize,ent,Float:{-16.0,-16.0,0.0},Float:{16.0,16.0,2.0})
	
	drop_to_floor(ent)
	
	entity_set_float(ent,EV_FL_nextthink,halflife_time() + 0.01) 
	
	use_addtofullpack = true
	
	return PLUGIN_CONTINUE
}

public Mine_Think(ent)
{
	if (!freeze_ended)
		remove_entity(ent)
	else
		entity_set_float(ent,EV_FL_nextthink,halflife_time() + 1.0) 
}

/* ==================================================================================================== */

public item_teamshield(id)
{
	if (used_item[id])
	{
		RemoveFlag(id,Flag_Teamshield)
		used_item[id] = false
	}
	else
	{
		new target = Find_Best_Angle(id,1000.0,true)
		
		if (!is_valid_ent(target))
		{
			hudmsg(id,2.0,"No targets in range to shield")
			return PLUGIN_CONTINUE
		}
		
		if (pev(target,pev_rendermode) == kRenderTransTexture || player_item_id[target] == 17)
		{
			hudmsg(id,2.0,"Can not cast shield on invisible players")
			return PLUGIN_CONTINUE
		}
		
		if (find_ent_by_owner(-1,"Effect_Teamshield",id) > 0)
			return PLUGIN_CONTINUE
		
		new ent = Spawn_Ent("info_target")
		set_pev(ent,pev_classname,"Effect_Teamshield")
		set_pev(ent,pev_owner,id)
		set_pev(ent,pev_solid,SOLID_NOT)
		set_pev(ent,pev_nextthink, halflife_time() + 0.1)	
		set_pev(ent,pev_euser2, target)	
				
		AddFlag(id,Flag_Teamshield)
		AddFlag(target,Flag_Teamshield_Target)
		used_item[id] = true
	}
	
	return PLUGIN_CONTINUE
}

public Effect_Teamshield_Think(ent)
{
	new id = pev(ent,pev_owner)
	new victim = pev(ent,pev_euser2)
	new target = Find_Best_Angle(id,750.0,true)

				
	if (!is_valid_ent(target) || !is_user_alive(id) || !is_user_alive(victim) || !Can_Trace_Line(id,victim) || !UTIL_In_FOV(id,victim) || !HasFlag(id,Flag_Teamshield) || !freeze_ended)
	{
		set_rendering (victim, kRenderFxNone, 0,0,0, kRenderFxNone, 0 ) 
		RemoveFlag(id,Flag_Teamshield)
		RemoveFlag(victim,Flag_Teamshield_Target)
		remove_entity(ent)
		return PLUGIN_CONTINUE
	}
	else		
		set_pev(ent,pev_nextthink, halflife_time() + 0.3)
				
	new origin1[3]
	new origin2[3]
	
	get_user_origin(id,origin1)
	get_user_origin(victim,origin2)
	
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY) 
	write_byte (TE_BEAMPOINTS)
	write_coord(origin1[0])
	write_coord(origin1[1])
	write_coord(origin1[2]+8)
	write_coord(origin2[0])
	write_coord(origin2[1])
	write_coord(origin2[2]+8)
	write_short(sprite_laser);
	write_byte(1) // framestart 
	write_byte(1) // framerate 
	write_byte(3) // life 
	write_byte(5) // width 
	write_byte(10) // noise 
	write_byte(0) // r, g, b (red)
	write_byte(255) // r, g, b (green)
	write_byte(0) // r, g, b (blue)
	write_byte(45) // brightness 
	write_byte(5) // speed 
	message_end()    
	
	set_rendering ( victim, kRenderFxGlowShell, 0,200,0, kRenderFxNone, 0 ) 
	
	return PLUGIN_CONTINUE
}

/* ==================================================================================================== */	

//Find the owner that has target as target and the specific classname
public find_owner_by_euser(target,classname[])
{
	new ent = -1
	ent = find_ent_by_class(ent,classname)

	while (ent > 0)
	{
		if (pev(ent,pev_euser2) == target)
			return pev(ent,pev_owner)
		ent = find_ent_by_class(ent,classname)
	}
	
	return -1
}

/* ==================================================================================================== */

public item_totemheal(id)
{
	if (used_item[id])
	{
		hudmsg(id,2.0,"You can only place one healing totem each round")
		return PLUGIN_CONTINUE
	}
	
	used_item[id] = true
	
	new origin[3]
	pev(id,pev_origin,origin)
		
	new ent = Spawn_Ent("info_target")
	set_pev(ent,pev_classname,"Effect_Healing_Totem")
	set_pev(ent,pev_owner,id)
	set_pev(ent,pev_solid,SOLID_TRIGGER)
	set_pev(ent,pev_origin,origin)
	set_pev(ent,pev_ltime, halflife_time() + 7 + 0.1)
	
	engfunc(EngFunc_SetModel, ent, "addons/amxmodx/diablo/totem_heal.mdl")  	
	set_rendering ( ent, kRenderFxGlowShell, 255,0,0, kRenderFxNone, 255 ) 	
	engfunc(EngFunc_DropToFloor,ent)
	
	set_pev(ent,pev_nextthink, halflife_time() + 0.1)
	
	return PLUGIN_CONTINUE	
}

public Effect_Healing_Totem_Think(ent)
{
	new id = pev(ent,pev_owner)
	new totem_dist = 300
	new amount_healed = player_b_heal[id]
	
	//We have emitted beam. Apply effect (this is delayed)
	if (pev(ent,pev_euser2) == 1)
	{		
		new Float:forigin[3], origin[3]
		pev(ent,pev_origin,forigin)	
		FVecIVec(forigin,origin)
		
		//Find people near and damage them
		new entlist[513]
		new numfound = find_sphere_class(0,"player",totem_dist+0.0,entlist,512,forigin)
		
		for (new i=0; i < numfound; i++)
		{		
			new pid = entlist[i]
			
			if (get_user_team(pid) != get_user_team(id))
				continue
				
				
			if (is_user_alive(pid) && get_user_health(pid) + amount_healed < 100+player_strength[pid]*2)
				set_user_health(pid,get_user_health(pid)+amount_healed)
			else
				set_user_health(pid,100+player_strength[pid]*2)				
		}
		
		
		set_pev(ent,pev_euser2,0)
		set_pev(ent,pev_nextthink, halflife_time() + 1.5)
		
		return PLUGIN_CONTINUE
	}
	
	
	//Entity should be destroyed because livetime is over
	if (pev(ent,pev_ltime) < halflife_time() || !is_user_alive(id))
	{
		remove_entity(ent)
		return PLUGIN_CONTINUE
	}
	
	
	
	//If this object is almost dead, apply some render to make it fade out
	if (pev(ent,pev_ltime)-2.0 < halflife_time())
		set_rendering ( ent, kRenderFxNone, 255,255,255, kRenderTransAlpha, 100 ) 
		
		
	
	new Float:forigin[3], origin[3]
	pev(ent,pev_origin,forigin)	
	FVecIVec(forigin,origin)
	
	
					
	//Find people near and give them health
	message_begin( MSG_BROADCAST, SVC_TEMPENTITY, origin );
	write_byte( TE_BEAMCYLINDER );
	write_coord( origin[0] );
	write_coord( origin[1] );
	write_coord( origin[2] );
	write_coord( origin[0] );
	write_coord( origin[1] + totem_dist );
	write_coord( origin[2] + totem_dist );
	write_short( sprite_white );
	write_byte( 0 ); // startframe
	write_byte( 0 ); // framerate
	write_byte( 10 ); // life
	write_byte( 10 ); // width
	write_byte( 255 ); // noise
	write_byte( 255 ); // r, g, b
	write_byte( 100 ); // r, g, b
	write_byte( 100 ); // r, g, b
	write_byte( 128 ); // brightness
	write_byte( 5 ); // speed
	message_end();
	
	//Time till we apply totems effect
		
	set_pev(ent,pev_euser2,1)
	set_pev(ent,pev_nextthink, halflife_time() + 0.5)
	
	    
	return PLUGIN_CONTINUE

}
